/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.List;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.go.impl.TypeImpl;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.plugins.go.api.MapTypeTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.Type;

public class MapTypeTreeImpl
extends BaseTreeImpl
implements MapTypeTree {
    private final Tree key;
    private final Tree value;
    private final Type type;

    public MapTypeTreeImpl(TreeMetaData metaData, Tree key, Tree value) {
        super(metaData);
        this.key = key;
        this.value = value;
        this.type = this.computeMapType();
    }

    @Override
    public List<Tree> children() {
        return List.of(this.key, this.value);
    }

    @Override
    public Tree key() {
        return this.key;
    }

    @Override
    public Tree value() {
        return this.value;
    }

    @Override
    public Type type() {
        return this.type;
    }

    private Type computeMapType() {
        Type keyType = ExpressionUtils.getTypeOfTree(this.key);
        Type valueType = ExpressionUtils.getTypeOfTree(this.value);
        return new TypeImpl(String.format("map[%s]%s", keyType.type(), valueType.type()), "");
    }
}

