/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.math.BigInteger;
import org.sonar.go.impl.LiteralTreeImpl;
import org.sonar.plugins.go.api.IntegerLiteralTree;
import org.sonar.plugins.go.api.TreeMetaData;

public class IntegerLiteralTreeImpl
extends LiteralTreeImpl
implements IntegerLiteralTree {
    private final IntegerLiteralTree.Base base;
    private final String numericPart;

    public IntegerLiteralTreeImpl(TreeMetaData metaData, String stringValue) {
        super(metaData, stringValue);
        String numeric = "";
        if (IntegerLiteralTreeImpl.hasExplicitHexadecimalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.HEXADECIMAL;
            numeric = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitBinaryPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.BINARY;
            numeric = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitDecimalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.DECIMAL;
            numeric = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitOctalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.OCTAL;
            numeric = stringValue.substring(2);
        } else if (!stringValue.equals("0") && stringValue.startsWith("0")) {
            this.base = IntegerLiteralTree.Base.OCTAL;
            numeric = stringValue.substring(1);
        } else {
            this.base = IntegerLiteralTree.Base.DECIMAL;
            numeric = stringValue;
        }
        this.numericPart = numeric.replace("_", "");
    }

    @Override
    public IntegerLiteralTree.Base getBase() {
        return this.base;
    }

    @Override
    public BigInteger getIntegerValue() {
        return new BigInteger(this.numericPart, this.base.getRadix());
    }

    @Override
    public String getNumericPart() {
        return this.numericPart;
    }

    private static boolean hasExplicitOctalPrefix(String value) {
        return value.startsWith("0o") || value.startsWith("0O");
    }

    private static boolean hasExplicitHexadecimalPrefix(String value) {
        return value.startsWith("0x") || value.startsWith("0X");
    }

    private static boolean hasExplicitBinaryPrefix(String value) {
        return value.startsWith("0b") || value.startsWith("0B");
    }

    private static boolean hasExplicitDecimalPrefix(String value) {
        return value.startsWith("0d") || value.startsWith("0D");
    }
}

