/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.FunctionInvocationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.MemberSelectTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.Type;

public class FunctionInvocationTreeImpl
extends BaseTreeImpl
implements FunctionInvocationTree {
    private static final String UNKNOWN = "UNKNOWN";
    private final Tree memberSelect;
    private final List<Tree> arguments;
    private final List<Type> returnTypes;

    public FunctionInvocationTreeImpl(TreeMetaData metaData, Tree memberSelect, List<Tree> arguments, List<Type> returnTypes) {
        super(metaData);
        this.memberSelect = memberSelect;
        this.arguments = arguments;
        this.returnTypes = returnTypes;
    }

    @Override
    public List<Tree> arguments() {
        return this.arguments;
    }

    @Override
    public String signature() {
        StringBuilder sb = new StringBuilder();
        Tree tree = this.memberSelect;
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            prefix = FunctionInvocationTreeImpl.retrieveSignaturePrefix(memberSelectTree);
            if (prefix != null) {
                sb.append((String)prefix).append('.');
            }
            sb.append(memberSelectTree.identifier().name());
        } else {
            prefix = this.memberSelect;
            if (prefix instanceof IdentifierTree) {
                IdentifierTree identifierTree = (IdentifierTree)prefix;
                String idSignature = FunctionInvocationTreeImpl.getPackageForIdentifierTreeOnly(identifierTree);
                if (!idSignature.isBlank()) {
                    sb.append(idSignature);
                    sb.append(".");
                }
                sb.append(identifierTree.name());
            } else {
                tree = this.memberSelect;
                if (tree instanceof FunctionDeclarationTree) {
                    FunctionDeclarationTree functionDeclarationTree = (FunctionDeclarationTree)tree;
                    sb.append(functionDeclarationTree.signature());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public List<Type> returnTypes() {
        return this.returnTypes;
    }

    @CheckForNull
    private static String retrieveSignaturePrefix(MemberSelectTree memberSelectTree) {
        FunctionInvocationTree functionInvocationTree;
        List<Type> returnedTypes;
        String result = null;
        Tree tree = memberSelectTree.expression();
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree2 = (MemberSelectTree)tree;
            result = FunctionInvocationTreeImpl.getPackageForMemberSelectExpression(memberSelectTree2.identifier());
        } else if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            result = FunctionInvocationTreeImpl.getPackageForMemberSelectExpression(identifierTree);
        } else if (tree instanceof FunctionInvocationTree && (returnedTypes = (functionInvocationTree = (FunctionInvocationTree)tree).returnTypes()).size() == 1) {
            result = returnedTypes.get(0).type();
        }
        return result;
    }

    private static String getPackageForMemberSelectExpression(IdentifierTree identifierTree) {
        String result = identifierTree.packageName();
        if (UNKNOWN.equals(result)) {
            result = identifierTree.type();
        }
        return result;
    }

    private static String getPackageForIdentifierTreeOnly(IdentifierTree identifierTree) {
        String packageName = identifierTree.packageName();
        if (!UNKNOWN.equals(packageName)) {
            return packageName;
        }
        return "";
    }

    @Override
    public Tree memberSelect() {
        return this.memberSelect;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.memberSelect);
        children.addAll(this.arguments);
        return children;
    }
}

