/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.go.impl.TextRanges;
import org.sonar.go.utils.NativeKinds;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.cfg.ControlFlowGraph;

public class FunctionDeclarationTreeImpl
extends BaseTreeImpl
implements FunctionDeclarationTree {
    @Nullable
    private final Tree returnType;
    @Nullable
    private final Tree receiver;
    @Nullable
    private final IdentifierTree name;
    private final List<Tree> formalParameters;
    @Nullable
    private final Tree typeParameters;
    @Nullable
    private final BlockTree body;
    private final List<Tree> children = new ArrayList<Tree>();
    private String receiverName;
    private String receiverType;
    private boolean isReceiverNameCalculated;
    private boolean isReceiverTypeCalculated;
    @Nullable
    private final ControlFlowGraph cfg;

    public FunctionDeclarationTreeImpl(TreeMetaData metaData, @Nullable Tree returnType, @Nullable Tree receiver, @Nullable IdentifierTree name, List<Tree> formalParameters, @Nullable Tree typeParameters, @Nullable BlockTree body, @Nullable ControlFlowGraph cfg) {
        super(metaData);
        this.returnType = returnType;
        this.receiver = receiver;
        this.name = name;
        this.formalParameters = formalParameters;
        this.typeParameters = typeParameters;
        this.body = body;
        this.cfg = cfg;
        if (returnType != null) {
            this.children.add(returnType);
        }
        if (receiver != null) {
            this.children.add(receiver);
        }
        if (name != null) {
            this.children.add(name);
        }
        this.children.addAll(formalParameters);
        if (typeParameters != null) {
            this.children.add(typeParameters);
        }
        if (body != null) {
            this.children.add(body);
        }
    }

    @Override
    @CheckForNull
    public Tree returnType() {
        return this.returnType;
    }

    @Override
    @CheckForNull
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    public List<Tree> formalParameters() {
        return this.formalParameters;
    }

    @Override
    @CheckForNull
    public Tree typeParameters() {
        return this.typeParameters;
    }

    @Override
    @CheckForNull
    public BlockTree body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Tree receiver() {
        return this.receiver;
    }

    @Override
    @CheckForNull
    public String receiverName() {
        if (!this.isReceiverNameCalculated) {
            this.receiverName = Stream.of(this.receiver).filter(Objects::nonNull).flatMap(Tree::descendants).filter(NativeKinds::isMethodReceiverTreeIdentifier).map(Tree::children).flatMap(Collection::stream).filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).map(IdentifierTree::name).findFirst().orElse(null);
            this.isReceiverNameCalculated = true;
        }
        return this.receiverName;
    }

    @Override
    @CheckForNull
    public String receiverType() {
        if (!this.isReceiverTypeCalculated) {
            this.receiverType = Stream.of(this.receiver).filter(Objects::nonNull).flatMap(Tree::descendants).filter(NativeKinds::isMethodReceiverTreeIdentifier).map(Tree::children).flatMap(Collection::stream).filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).map(IdentifierTree::type).findFirst().orElse(null);
            this.isReceiverTypeCalculated = true;
        }
        return this.receiverType;
    }

    @Override
    public TextRange rangeToHighlight() {
        if (this.name != null) {
            return this.name.metaData().textRange();
        }
        if (this.body == null) {
            return this.metaData().textRange();
        }
        TextRange bodyRange = this.body.metaData().textRange();
        List<TextRange> tokenRangesBeforeBody = this.metaData().tokens().stream().map(HasTextRange::textRange).filter(t -> t.start().compareTo(bodyRange.start()) < 0).toList();
        if (tokenRangesBeforeBody.isEmpty()) {
            return bodyRange;
        }
        return TextRanges.merge(tokenRangesBeforeBody);
    }

    @Override
    public ControlFlowGraph cfg() {
        return this.cfg;
    }

    @Override
    public String signature() {
        StringBuilder sb = new StringBuilder();
        String receiverTypeLocal = this.receiverType();
        if (receiverTypeLocal != null) {
            sb.append(receiverTypeLocal);
            sb.append(".");
        } else if (this.name != null) {
            sb.append(this.name.packageName());
            sb.append(".");
        }
        if (this.name != null) {
            sb.append(this.name.name());
        } else {
            sb.append("$anonymous_at_line_");
            sb.append(this.metaData().textRange().start().line());
        }
        return sb.toString();
    }

    @Override
    public List<Tree> children() {
        return this.children;
    }
}

