/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.plugins.go.api.CompositeLiteralTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.KeyValueTree;
import org.sonar.plugins.go.api.MemberSelectTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;

public class CompositeLiteralTreeImpl
extends BaseTreeImpl
implements CompositeLiteralTree {
    @Nullable
    private final Tree type;
    private final List<Tree> elements;

    public CompositeLiteralTreeImpl(TreeMetaData metaData, @Nullable Tree type, List<Tree> elements) {
        super(metaData);
        this.type = type;
        this.elements = elements;
    }

    @Override
    @CheckForNull
    public Tree type() {
        return this.type;
    }

    @Override
    public List<Tree> elements() {
        return this.elements;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (this.type != null) {
            children.add(this.type);
        }
        children.addAll(this.elements);
        return children;
    }

    @Override
    public Stream<KeyValueTree> getKeyValuesElements() {
        return this.elements.stream().filter(KeyValueTree.class::isInstance).map(KeyValueTree.class::cast);
    }

    @Override
    public boolean hasType(String packageName, String typeName) {
        Tree tree = this.type;
        if (tree instanceof MemberSelectTree) {
            IdentifierTree identifierTree;
            Tree tree2;
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return typeName.equals(memberSelectTree.identifier().type()) && (tree2 = memberSelectTree.expression()) instanceof IdentifierTree && packageName.equals((identifierTree = (IdentifierTree)tree2).packageName());
        }
        tree = this.type;
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)tree;
            return typeName.equals(identifierTree.type()) && packageName.equals(identifierTree.packageName());
        }
        return false;
    }
}

