/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.go.impl.BaseTreeImpl;
import org.sonar.go.impl.EllipsisTreeImpl;
import org.sonar.go.impl.TypeImpl;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.plugins.go.api.ArrayTypeTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.IntegerLiteralTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.Type;

public class ArrayTypeTreeImpl
extends BaseTreeImpl
implements ArrayTypeTree {
    @Nullable
    private final Tree ellipsis;
    private final Tree element;
    private final List<Tree> children;
    private final Type type;

    public ArrayTypeTreeImpl(TreeMetaData metaData, @Nullable Tree ellipsis, Tree element) {
        super(metaData);
        this.ellipsis = ellipsis;
        this.element = element;
        this.children = new ArrayList<Tree>();
        if (ellipsis != null) {
            this.children.add(ellipsis);
        }
        this.children.add(element);
        this.type = this.computeArrayType();
    }

    @Override
    @CheckForNull
    public Tree length() {
        return this.ellipsis;
    }

    @Override
    public Tree element() {
        return this.element;
    }

    @Override
    public Type type() {
        return this.type;
    }

    private Type computeArrayType() {
        String lengthValue;
        if (this.ellipsis == null) {
            lengthValue = "";
        } else {
            Tree tree = this.ellipsis;
            if (tree instanceof IntegerLiteralTree) {
                IntegerLiteralTree lengthAsInt = (IntegerLiteralTree)tree;
                lengthValue = lengthAsInt.value();
            } else if (this.ellipsis instanceof EllipsisTreeImpl) {
                lengthValue = "...";
            } else {
                tree = this.ellipsis;
                if (tree instanceof IdentifierTree) {
                    IdentifierTree lengthAsIdentifier = (IdentifierTree)tree;
                    lengthValue = lengthAsIdentifier.name();
                } else {
                    return TypeImpl.UNKNOWN_TYPE;
                }
            }
        }
        return new TypeImpl(String.format("[%s]%s", lengthValue, ExpressionUtils.getTypeOfTree(this.element).type()), "");
    }

    @Override
    public List<Tree> children() {
        return this.children;
    }
}

