/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import java.io.File;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.go.externalreport.AbstractPropertyHandlerSensor;
import org.sonar.go.externalreport.CheckstyleFormatImporter;

public class GolangCILintReportSensor
extends AbstractPropertyHandlerSensor {
    public static final String LINTER_ID = "golangci-lint";
    public static final String LINTER_NAME = "GolangCI-Lint";
    public static final String PROPERTY_KEY = "sonar.go.golangci-lint.reportPaths";

    public GolangCILintReportSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, LINTER_ID, LINTER_NAME, PROPERTY_KEY, "go");
    }

    @Override
    public Consumer<File> reportConsumer(SensorContext context) {
        return new GolangCILintCheckstyleFormatImporter(context, LINTER_ID)::importFile;
    }

    private static class GolangCILintCheckstyleFormatImporter
    extends CheckstyleFormatImporter {
        private static final Pattern GOVET_RULE_ID_PATTERN = Pattern.compile("^([a-z]+):");

        public GolangCILintCheckstyleFormatImporter(SensorContext context, String linterKey) {
            super(context, linterKey);
        }

        @Override
        protected RuleType ruleType(@Nullable String severity, String source) {
            if ("gosec".equals(source)) {
                return RuleType.VULNERABILITY;
            }
            return super.ruleType(severity, source);
        }

        @Override
        protected RuleKey createRuleKey(String source, RuleType ruleType, Severity ruleSeverity, String message) {
            Matcher matcher;
            if ("gosec".equals(source)) {
                return RuleKey.of((String)this.linterKey, (String)source);
            }
            if ("govet".equals(source) && (matcher = GOVET_RULE_ID_PATTERN.matcher(message)).find()) {
                String ruleKey = matcher.group(1);
                return RuleKey.of((String)"govet", (String)ruleKey);
            }
            String ruleKey = String.format("%s.%s.%s", source, ruleType.toString().toLowerCase(Locale.ROOT), ruleSeverity.toString().toLowerCase(Locale.ROOT));
            return RuleKey.of((String)this.linterKey, (String)ruleKey);
        }
    }
}

