/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rules.RuleType;
import org.sonar.go.externalreport.AbstractReportSensor;
import org.sonar.go.externalreport.ExternalIssue;
import org.sonar.go.utils.LogArg;

public class GoLintReportSensor
extends AbstractReportSensor {
    private static final Logger LOG = LoggerFactory.getLogger(GoLintReportSensor.class);
    public static final String PROPERTY_KEY = "sonar.go.golint.reportPaths";
    private static final Pattern GO_LINT_LINE_REGEX = Pattern.compile("(?<file>[^:]+):(?<line>\\d+):\\d*:(?<message>.*)");
    public static final String LINTER_ID = "golint";
    public static final String LINTER_NAME = "Golint";

    public GoLintReportSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, LINTER_ID, LINTER_NAME, PROPERTY_KEY);
    }

    @Override
    @Nullable
    ExternalIssue parse(String line) {
        Matcher matcher = GO_LINT_LINE_REGEX.matcher(line);
        if (matcher.matches()) {
            String filename = matcher.group("file").trim();
            int lineNumber = Integer.parseInt(matcher.group("line").trim());
            String message = matcher.group("message").trim();
            return new ExternalIssue(LINTER_ID, RuleType.CODE_SMELL, null, filename, lineNumber, message);
        }
        LOG.debug("{}Unexpected line: {}", LogArg.lazyArg(this::logPrefix), (Object)line);
        return null;
    }
}

