/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public abstract class AbstractPropertyHandlerSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyHandlerSensor.class);
    private final AnalysisWarnings analysisWarnings;
    private final String propertyKey;
    private final String propertyName;
    private final String configurationKey;
    private final String languageKey;

    protected AbstractPropertyHandlerSensor(AnalysisWarnings analysisWarnings, String propertyKey, String propertyName, String configurationKey, String languageKey) {
        this.analysisWarnings = analysisWarnings;
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.configurationKey = configurationKey;
        this.languageKey = languageKey;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public final String propertyKey() {
        return this.propertyKey;
    }

    public final String configurationKey() {
        return this.configurationKey;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(this.languageKey).onlyWhenConfiguration(conf -> conf.hasKey(this.configurationKey())).name("Import of " + this.propertyName() + " issues");
    }

    public void execute(SensorContext context) {
        this.executeOnFiles(this.reportFiles(context), this.reportConsumer(context));
    }

    public abstract Consumer<File> reportConsumer(SensorContext var1);

    private void executeOnFiles(List<File> reportFiles, Consumer<File> action) {
        reportFiles.stream().filter(File::exists).forEach(file -> {
            LOG.info("Importing {}", file);
            action.accept((File)file);
        });
        this.reportMissingFiles(reportFiles);
    }

    private List<File> reportFiles(SensorContext context) {
        return ExternalReportProvider.getReportFiles(context, this.configurationKey());
    }

    private void reportMissingFiles(List<File> reportFiles) {
        List<String> missingFiles = reportFiles.stream().filter(file -> !file.exists()).map(File::getPath).toList();
        if (!missingFiles.isEmpty()) {
            String missingFilesAsString = missingFiles.stream().collect(Collectors.joining("\n- ", "\n- ", ""));
            String logWarning = String.format("Unable to import %s report file(s):%s%nThe report file(s) can not be found. Check that the property '%s' is correctly configured.", this.propertyName(), missingFilesAsString, this.configurationKey());
            LOG.warn(logWarning);
            String uiWarning = String.format("Unable to import %d %s report file(s).%nPlease check that property '%s' is correctly configured and the analysis logs for more details.", missingFiles.size(), this.propertyName(), this.configurationKey());
            this.analysisWarnings.addUnique(uiWarning);
        }
    }
}

