/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.converter;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.go.converter.DefaultCommand;
import org.sonar.go.converter.PlatformInfo;
import org.sonar.go.converter.SystemPlatformInfo;

public class GoParseCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GoParseCommand.class);
    private final int moduleNameIndex = super.getCommand().indexOf("moduleNamePlaceholder");

    public GoParseCommand(File workDir, String ... extraArgs) {
        this(workDir, new SystemPlatformInfo(), extraArgs);
    }

    public GoParseCommand(File workDir, PlatformInfo platformInfo, String ... extraArgs) {
        super(workDir, platformInfo, GoParseCommand.mergeArgs(extraArgs, "-module_name", "moduleNamePlaceholder", "-gc_export_data_dir", new File(workDir, "go").getAbsolutePath()));
    }

    private static String[] mergeArgs(String[] args, String ... extraArgs) {
        if (args.length == 0) {
            return extraArgs;
        }
        String[] merged = new String[args.length + extraArgs.length];
        System.arraycopy(args, 0, merged, 0, args.length);
        System.arraycopy(extraArgs, 0, merged, args.length, extraArgs.length);
        return merged;
    }

    public String executeGoParseCommand(Map<String, String> filenameToContentMap, String moduleName) throws IOException, InterruptedException {
        this.command.set(this.moduleNameIndex, moduleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing Go parse data command: {}", (Object)String.join((CharSequence)" ", this.command));
        }
        return super.executeCommand(filenameToContentMap);
    }
}

