/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.converter;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.go.converter.GoParseCommand;
import org.sonar.go.converter.InitializationException;
import org.sonar.go.converter.PlatformInfo;
import org.sonar.go.converter.SystemPlatformInfo;
import org.sonar.go.persistence.JsonTree;
import org.sonar.plugins.go.api.ASTConverter;
import org.sonar.plugins.go.api.ParseException;
import org.sonar.plugins.go.api.TreeOrError;

public class GoConverter
implements ASTConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GoConverter.class);
    public static final long MAX_SUPPORTED_SOURCE_FILE_SIZE = 1500000L;
    private final GoParseCommand command;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public GoConverter(File workDir) {
        this(workDir, new SystemPlatformInfo());
    }

    public GoConverter(File workDir, PlatformInfo platformInfo) {
        GoParseCommand commandOrNull;
        try {
            commandOrNull = new GoParseCommand(workDir, platformInfo, new String[0]);
            this.isInitialized.set(true);
        }
        catch (InitializationException e) {
            LOG.warn("Go converter initialization failed: {}", (Object)e.getMessage());
            commandOrNull = null;
        }
        this.command = commandOrNull;
    }

    public GoConverter(GoParseCommand command) {
        this.command = command;
        this.isInitialized.set(true);
    }

    @Override
    public Map<String, TreeOrError> parse(Map<String, String> filenameToContentMap, String moduleName) {
        HashMap<String, TreeOrError> result = new HashMap<String, TreeOrError>(filenameToContentMap.size());
        HashMap<String, String> filesToParse = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : filenameToContentMap.entrySet()) {
            String filename = entry.getKey();
            String content = entry.getValue();
            if ((long)content.length() > 1500000L) {
                result.put(filename, TreeOrError.of("The file size is too big and should be excluded, its size is " + content.length() + " (maximum allowed is 1500000 bytes)"));
                continue;
            }
            filesToParse.put(filename, content);
        }
        try {
            String json = this.command.executeGoParseCommand(filesToParse, moduleName);
            result.putAll(JsonTree.fromJson(json));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ParseException("Go executable interrupted: " + e.getMessage(), null, e);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), null, e);
        }
        return result;
    }

    @Override
    public void debugTypeCheck() {
        this.command.debugTypeCheck();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized.get();
    }
}

