/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.converter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessStreamConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcessStreamConsumer.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("stream-consumer");
        thread.setDaemon(true);
        return thread;
    });

    public final void consumeStream(InputStream inputStream, StreamConsumer streamConsumer) {
        this.executorService.submit(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                this.readErrors(errorReader, streamConsumer);
            }
            catch (IOException e) {
                LOG.warn("Failure while reading stream", (Throwable)e);
            }
        });
    }

    protected void readErrors(BufferedReader errorReader, StreamConsumer streamConsumer) {
        errorReader.lines().forEach(streamConsumer::consumeLine);
        streamConsumer.finished();
    }

    public void shutdown() {
        if (this.executorService == null) {
            return;
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static interface StreamConsumer {
        public void consumeLine(String var1);

        default public void finished() {
        }
    }
}

