/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.go.converter.Command;
import org.sonar.go.converter.ExternalProcessStreamConsumer;
import org.sonar.go.converter.InitializationException;
import org.sonar.go.converter.PlatformInfo;
import org.sonar.go.converter.SystemPlatformInfo;
import org.sonar.plugins.go.api.ParseException;

public class DefaultCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCommand.class);
    private static final long PROCESS_TIMEOUT_MS = 5000L;
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final int FILENAME_AND_CONTENT_LENGTH = 8;
    protected final List<String> command;

    public DefaultCommand(File workDir, String ... arguments) {
        this(workDir, new SystemPlatformInfo(), arguments);
    }

    public DefaultCommand(File workDir, PlatformInfo platformInfo, String ... arguments) {
        try {
            this.command = new ArrayList<String>();
            String executable = DefaultCommand.extract(workDir, platformInfo);
            this.command.add(executable);
            this.command.addAll(Arrays.asList(arguments));
        }
        catch (IOException e) {
            throw new InitializationException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeCommand(Map<String, String> filenameToContentMap) throws IOException, InterruptedException {
        List<ByteBuffer> byteBuffers = DefaultCommand.convertToBytesArray(filenameToContentMap);
        ProcessBuilder processBuilder = new ProcessBuilder(this.getCommand());
        ExternalProcessStreamConsumer errorConsumer = new ExternalProcessStreamConsumer();
        Process process = processBuilder.start();
        try {
            String output;
            errorConsumer.consumeStream(process.getErrorStream(), arg_0 -> ((Logger)LOG).debug(arg_0));
            try (OutputStream out = process.getOutputStream();){
                for (ByteBuffer byteBuffer : byteBuffers) {
                    out.write(byteBuffer.array());
                }
            }
            try (InputStream in = process.getInputStream();){
                output = DefaultCommand.readAsString(in);
            }
            boolean exited = process.waitFor(5000L, TimeUnit.MILLISECONDS);
            if (exited && process.exitValue() != 0) {
                throw new ParseException("Go executable returned non-zero exit value: " + process.exitValue());
            }
            if (process.isAlive()) {
                process.destroyForcibly();
                throw new ParseException("Go executable took too long. External process killed forcibly");
            }
            String string = output;
            return string;
        }
        finally {
            errorConsumer.shutdown();
        }
    }

    public void debugTypeCheck() {
        this.command.add("-debug_type_check");
    }

    private static List<ByteBuffer> convertToBytesArray(Map<String, String> filenameToContentMap) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, String> filenameToContent : filenameToContentMap.entrySet()) {
            byte[] filenameBytes = filenameToContent.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] contentBytes = filenameToContent.getValue().getBytes(StandardCharsets.UTF_8);
            int capacity = filenameBytes.length + contentBytes.length + 8;
            ByteBuffer byteBuffer = ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN).putInt(filenameBytes.length).put(filenameBytes).putInt(contentBytes.length).put(contentBytes);
            buffers.add(byteBuffer);
        }
        return buffers;
    }

    private static String readAsString(InputStream in) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DefaultCommand.copy(in, outputStream);
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    private static String extract(File workDir, PlatformInfo platformInfo) throws IOException {
        byte[] executableData;
        String executable = DefaultCommand.getExecutableForCurrentOS(platformInfo.osName(), platformInfo.osArch());
        File dest = new File(workDir, executable);
        if (!DefaultCommand.fileMatch(dest, executableData = DefaultCommand.getBytesFromResource(executable))) {
            workDir.mkdirs();
            Files.write(dest.toPath(), executableData, new OpenOption[0]);
            dest.setExecutable(true);
        }
        return dest.getAbsolutePath();
    }

    static boolean fileMatch(File dest, byte[] expectedContent) throws IOException {
        if (!dest.exists()) {
            return false;
        }
        byte[] actualContent = Files.readAllBytes(dest.toPath());
        return Arrays.equals(actualContent, expectedContent);
    }

    static byte[] getBytesFromResource(String executable) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = DefaultCommand.class.getClassLoader().getResourceAsStream(executable);){
            if (in == null) {
                throw new InitializationException(executable + " binary not found on class path");
            }
            DefaultCommand.copy(in, out);
        }
        return out.toByteArray();
    }

    static String getExecutableForCurrentOS(String osName, String arch) {
        boolean isPlatformSupported;
        Object suffix;
        String os = osName.toLowerCase(Locale.ROOT);
        String extension = "";
        if (os.contains("win")) {
            suffix = "windows";
            extension = ".exe";
        } else {
            suffix = os.contains("mac") ? "darwin" : "linux";
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch) || "armv8".equals(arch)) {
            suffix = (String)suffix + "-arm64";
        } else if ("x86_64".equals(arch) || "amd64".equals(arch) || "x64".equals(arch)) {
            suffix = (String)suffix + "-amd64";
        }
        switch (suffix) {
            case "windows-amd64": 
            case "linux-amd64": 
            case "darwin-amd64": 
            case "linux-arm64": 
            case "darwin-arm64": {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = isPlatformSupported = false;
            }
        }
        if (isPlatformSupported) {
            String binaryName = "sonar-go-to-slang-" + (String)suffix + extension;
            LOG.debug("Using Go converter binary: {}", (Object)binaryName);
            return binaryName;
        }
        throw new InitializationException("Unsupported OS/architecture: " + osName + "/" + arch);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }
}

