/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks.complexity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.go.impl.JumpTreeImpl;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.go.visitors.TreeContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.CatchTree;
import org.sonar.plugins.go.api.ClassDeclarationTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.IfTree;
import org.sonar.plugins.go.api.LoopTree;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;

public class CognitiveComplexity {
    private List<Increment> increments = new ArrayList<Increment>();

    public CognitiveComplexity(Tree root) {
        CognitiveComplexityVisitor visitor = new CognitiveComplexityVisitor();
        visitor.scan(new TreeContext(), root);
    }

    public int value() {
        int total = 0;
        for (Increment increment : this.increments) {
            total += increment.nestingLevel + 1;
        }
        return total;
    }

    public List<Increment> increments() {
        return this.increments;
    }

    private class CognitiveComplexityVisitor
    extends TreeVisitor<TreeContext> {
        private Set<Token> alreadyConsideredOperators = new HashSet<Token>();

        private CognitiveComplexityVisitor() {
            this.register(LoopTree.class, (ctx, tree) -> this.incrementWithNesting(tree.keyword(), (TreeContext)ctx));
            this.register(MatchTree.class, (ctx, tree) -> this.incrementWithNesting(tree.keyword(), (TreeContext)ctx));
            this.register(CatchTree.class, (ctx, tree) -> this.incrementWithNesting(tree.keyword(), (TreeContext)ctx));
            this.register(JumpTreeImpl.class, (ctx, tree) -> {
                if (tree.label() != null) {
                    this.incrementWithoutNesting(tree.keyword());
                }
            });
            this.register(IfTree.class, (ctx, tree) -> {
                Token elseKeyword;
                IfTree ifTree;
                boolean isElseIf;
                Tree parent = ctx.ancestors().peek();
                boolean bl = isElseIf = parent instanceof IfTree && tree == (ifTree = (IfTree)parent).elseBranch();
                if (!isElseIf) {
                    this.incrementWithNesting(tree.ifKeyword(), (TreeContext)ctx);
                }
                if ((elseKeyword = tree.elseKeyword()) != null) {
                    this.incrementWithoutNesting(elseKeyword);
                }
            });
            this.register(BinaryExpressionTree.class, (ctx, tree) -> this.handleBinaryExpressions((BinaryExpressionTree)tree));
        }

        private void handleBinaryExpressions(BinaryExpressionTree tree) {
            if (!ExpressionUtils.isLogicalBinaryExpression(tree) || this.alreadyConsideredOperators.contains(tree.operatorToken())) {
                return;
            }
            ArrayList<Token> operators = new ArrayList<Token>();
            this.flattenOperators(tree, operators);
            Token previous = null;
            for (Token operator : operators) {
                if (previous == null || !previous.text().equals(operator.text())) {
                    this.incrementWithoutNesting(operator);
                }
                previous = operator;
                this.alreadyConsideredOperators.add(operator);
            }
        }

        private void flattenOperators(BinaryExpressionTree tree, List<Token> operators) {
            if (ExpressionUtils.isLogicalBinaryExpression(tree.leftOperand())) {
                this.flattenOperators((BinaryExpressionTree)tree.leftOperand(), operators);
            }
            operators.add(tree.operatorToken());
            if (ExpressionUtils.isLogicalBinaryExpression(tree.rightOperand())) {
                this.flattenOperators((BinaryExpressionTree)tree.rightOperand(), operators);
            }
        }

        private void incrementWithNesting(Token token, TreeContext ctx) {
            this.increment(token, this.nestingLevel(ctx));
        }

        private void incrementWithoutNesting(Token token) {
            this.increment(token, 0);
        }

        private void increment(Token token, int nestingLevel) {
            CognitiveComplexity.this.increments.add(new Increment(token, nestingLevel));
        }

        private int nestingLevel(TreeContext ctx) {
            int nestingLevel = 0;
            boolean isInsideFunction = false;
            Iterator<Tree> ancestors = ctx.ancestors().descendingIterator();
            Tree parent = null;
            while (ancestors.hasNext()) {
                Tree t = ancestors.next();
                if (t instanceof FunctionDeclarationTree) {
                    if (isInsideFunction || nestingLevel > 0) {
                        ++nestingLevel;
                    }
                    isInsideFunction = true;
                } else if (t instanceof IfTree && !this.isElseIfBranch(parent, t) || t instanceof MatchTree || t instanceof LoopTree || t instanceof CatchTree) {
                    ++nestingLevel;
                } else if (t instanceof ClassDeclarationTree) {
                    nestingLevel = 0;
                    isInsideFunction = false;
                }
                parent = t;
            }
            return nestingLevel;
        }

        private boolean isElseIfBranch(@Nullable Tree parent, Tree tree) {
            IfTree ifTree;
            return parent instanceof IfTree && (ifTree = (IfTree)parent).elseBranch() == tree;
        }
    }

    public static class Increment {
        private final Token token;
        private final int nestingLevel;

        private Increment(Token token, int nestingLevel) {
            this.token = token;
            this.nestingLevel = nestingLevel;
        }

        public Token token() {
            return this.token;
        }

        public int nestingLevel() {
            return this.nestingLevel;
        }
    }
}

