/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.go.impl.TextRanges;
import org.sonar.plugins.go.api.AssignmentExpressionTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.UnaryExpressionTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
implements GoCheck {
    private static final List<UnaryExpressionTree.Operator> SUSPICIOUS_UNARY_OPERATORS = List.of(UnaryExpressionTree.Operator.NEGATE, UnaryExpressionTree.Operator.PLUS, UnaryExpressionTree.Operator.MINUS);

    @Override
    public void initialize(InitContext init) {
        init.register(AssignmentExpressionTree.class, (ctx, assignment) -> {
            Token expressionFirstToken;
            Tree rightHandSide = assignment.statementOrExpression();
            if (assignment.operator() != AssignmentExpressionTree.Operator.EQUAL || !WrongAssignmentOperatorCheck.isSuspiciousUnaryExpression(rightHandSide)) {
                return;
            }
            List<Token> leftHandSideTokens = assignment.leftHandSide().metaData().tokens();
            Token variableLastToken = leftHandSideTokens.get(leftHandSideTokens.size() - 1);
            List<Token> allTokens = assignment.metaData().tokens();
            Token operatorToken = allTokens.get(allTokens.indexOf(variableLastToken) + 1);
            if (!WrongAssignmentOperatorCheck.hasSpacingBetween(operatorToken, expressionFirstToken = rightHandSide.metaData().tokens().get(0)) && WrongAssignmentOperatorCheck.hasSpacingBetween(variableLastToken, operatorToken)) {
                TextRange range = TextRanges.merge(Arrays.asList(operatorToken.textRange(), expressionFirstToken.textRange()));
                ctx.reportIssue(range, WrongAssignmentOperatorCheck.getMessage(expressionFirstToken));
            }
        });
    }

    private static String getMessage(Token expressionFirstToken) {
        if ("!".equals(expressionFirstToken.text())) {
            return "Add a space between \"=\" and \"!\" to avoid confusion.";
        }
        return "Was \"" + expressionFirstToken.text() + "=\" meant instead?";
    }

    private static boolean hasSpacingBetween(Token firstToken, Token secondToken) {
        return firstToken.textRange().end().line() != secondToken.textRange().start().line() || firstToken.textRange().end().lineOffset() != secondToken.textRange().start().lineOffset();
    }

    private static boolean isSuspiciousUnaryExpression(Tree tree) {
        UnaryExpressionTree unary;
        return tree instanceof UnaryExpressionTree && SUSPICIOUS_UNARY_OPERATORS.contains((Object)(unary = (UnaryExpressionTree)tree).operator());
    }
}

