/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.ParameterTree;
import org.sonar.plugins.go.api.VariableDeclarationTree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S117")
public class VariableAndParameterNameCheck
implements GoCheck {
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^(_|[a-zA-Z0-9]+)$")
    public String format = "^(_|[a-zA-Z0-9]+)$";

    @Override
    public void initialize(InitContext init) {
        Pattern pattern = Pattern.compile(this.format);
        init.register(VariableDeclarationTree.class, (ctx, tree) -> {
            if (ctx.ancestors().stream().anyMatch(FunctionDeclarationTree.class::isInstance)) {
                for (IdentifierTree identifier : tree.identifiers()) {
                    this.check(pattern, (CheckContext)ctx, identifier, "local variable");
                }
            }
        });
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> tree.formalParameters().stream().filter(ParameterTree.class::isInstance).map(ParameterTree.class::cast).forEach(param -> this.check(pattern, (CheckContext)ctx, param.identifier(), "parameter")));
    }

    private void check(Pattern pattern, CheckContext ctx, IdentifierTree identifier, String variableKind) {
        if (!pattern.matcher(identifier.name()).matches()) {
            String message = String.format("Rename this %s to match the regular expression \"%s\".", variableKind, this.format);
            ctx.reportIssue(identifier, message);
        }
    }
}

