/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S107")
public class TooManyParametersCheck
implements GoCheck {
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="Max", description="Maximum authorized number of parameters", defaultValue="7")
    public int max = 7;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.formalParameters().size() > this.max) {
                String message = String.format("This function has %s parameters, which is greater than the %s authorized.", tree.formalParameters().size(), this.max);
                List<SecondaryLocation> secondaryLocations = tree.formalParameters().stream().skip(this.max).map(SecondaryLocation::new).toList();
                IdentifierTree name = tree.name();
                if (name == null) {
                    ctx.reportIssue((HasTextRange)tree, message, secondaryLocations);
                } else {
                    ctx.reportIssue((HasTextRange)name, message, secondaryLocations);
                }
            }
        });
    }
}

