/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S104")
public class TooManyLinesOfCodeFileCheck
implements GoCheck {
    private static final int DEFAULT_MAX = 750;
    private static final String DEFAULT_MAX_VALUE = "750";
    @RuleProperty(key="Max", description="Maximum authorized lines of code in a file.", defaultValue="750")
    public int max = 750;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            int numberOfLinesOfCode = tree.metaData().linesOfCode().size();
            if (numberOfLinesOfCode > this.max) {
                String message = String.format("File \"%s\" has %s lines, which is greater than %s authorized. Split it into smaller files.", ctx.filename(), numberOfLinesOfCode, this.max);
                ctx.reportFileIssue(message);
            }
        });
    }
}

