/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S1479")
public class TooManyCasesCheck
implements GoCheck {
    private static final int DEFAULT_MAX = 30;
    @RuleProperty(key="maximum", description="Maximum number of branches", defaultValue="30")
    public int maximum = 30;

    @Override
    public void initialize(InitContext init) {
        init.register(MatchTree.class, (ctx, tree) -> {
            int numberOfCases = tree.cases().size();
            if (numberOfCases > this.maximum) {
                Token matchKeyword = tree.keyword();
                String message = String.format("Reduce the number of %s branches from %s to at most %s.", matchKeyword.text(), numberOfCases, this.maximum);
                List<SecondaryLocation> secondaryLocations = tree.cases().stream().map(matchCase -> new SecondaryLocation(matchCase.rangeToHighlight(), null)).toList();
                ctx.reportIssue((HasTextRange)matchKeyword, message, secondaryLocations);
            }
        });
    }
}

