/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.go.impl.TextPointerImpl;
import org.sonar.go.impl.TextRangeImpl;
import org.sonar.plugins.go.api.ImportSpecificationTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S103")
public class TooLongLineCheck
implements GoCheck {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    private static final String DEFAULT_MAXIMUM_LINE_LENGTH_VALUE = "120";
    private static final String MESSAGE = "Split this {0} characters long line (which is greater than {1} authorized).";
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="120")
    int maximumLineLength = 120;
    private final Map<Integer, TextRange> longLines = new HashMap<Integer, TextRange>();
    private final Set<Integer> linesWithTree = new HashSet<Integer>();
    private final Set<Integer> linesLongUrlComments = new HashSet<Integer>();

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, this::handleTopLevelTree);
        init.register(ImportSpecificationTree.class, (ctx, tree) -> this.longLines.remove(tree.textRange().start().line()));
        init.register(Tree.class, (ctx, tree) -> {
            int startLine = tree.textRange().start().line();
            this.linesWithTree.add(startLine);
        });
        init.registerOnLeave((ctx, tree) -> this.longLines.entrySet().stream().filter(entry -> !this.containsOnlyLongUrlComment((Integer)entry.getKey())).forEach(entry -> {
            String message = MessageFormat.format(MESSAGE, ((TextRange)entry.getValue()).end().lineOffset(), this.maximumLineLength);
            ctx.reportIssue((TextRange)entry.getValue(), message);
        }));
    }

    private boolean containsOnlyLongUrlComment(Integer lineNumber) {
        return this.linesLongUrlComments.contains(lineNumber) && !this.linesWithTree.contains(lineNumber);
    }

    private void handleTopLevelTree(CheckContext ctx, TopLevelTree topLevelTree) {
        this.longLines.clear();
        this.linesWithTree.clear();
        this.linesLongUrlComments.clear();
        String[] lines = ctx.fileContent().split("\r\n|\n|\r", -1);
        IntStream.range(0, lines.length).filter(lineNumber -> lines[lineNumber].length() > this.maximumLineLength).forEach(lineNumber -> {
            int lineLength = lines[lineNumber].length();
            TextRange longLine = TooLongLineCheck.getLineRange(lineNumber + 1, lineLength);
            this.longLines.put(lineNumber + 1, longLine);
        });
        topLevelTree.allComments().forEach(comment -> {
            String commentText;
            if (comment.textRange().end().lineOffset() > this.maximumLineLength && TooLongLineCheck.isOnlyUrl(commentText = comment.contentText().trim())) {
                int lineNumber = comment.textRange().start().line();
                this.linesLongUrlComments.add(lineNumber);
            }
        });
    }

    private static boolean isOnlyUrl(String commentText) {
        return commentText.contains("://") && !commentText.contains(" ") && !commentText.contains("\t");
    }

    private static TextRange getLineRange(int lineNumber, int lineLength) {
        return new TextRangeImpl(new TextPointerImpl(lineNumber, 0), new TextPointerImpl(lineNumber, lineLength));
    }
}

