/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S138")
public class TooLongFunctionCheck
implements GoCheck {
    private static final int DEFAULT_MAX = 120;
    private static final String DEFAULT_MAX_VALUE = "120";
    @RuleProperty(key="max", description="Maximum authorized lines of code in a function", defaultValue="120")
    public int max = 120;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            BlockTree body = tree.body();
            if (body == null) {
                return;
            }
            int numberOfLinesOfCode = body.metaData().linesOfCode().size();
            if (numberOfLinesOfCode > this.max) {
                String message = String.format("This function has %s lines of code, which is greater than the %s authorized. Split it into smaller functions.", numberOfLinesOfCode, this.max);
                ctx.reportIssue(tree.rangeToHighlight(), message);
            }
        });
    }
}

