/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.ExceptionHandlingTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.IfTree;
import org.sonar.plugins.go.api.LoopTree;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S134")
public class TooDeeplyNestedStatementsCheck
implements GoCheck {
    private static final int DEFAULT_MAX_DEPTH = 4;
    private static final String DEFAULT_MAX_DEPTH_VALUE = "4";
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth", defaultValue="4")
    public int max = 4;

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, this::checkNestedDepth);
        init.register(LoopTree.class, this::checkNestedDepth);
        init.register(MatchTree.class, this::checkNestedDepth);
        init.register(ExceptionHandlingTree.class, this::checkNestedDepth);
    }

    private void checkNestedDepth(CheckContext ctx, Tree tree) {
        if (TooDeeplyNestedStatementsCheck.isElseIfStatement(ctx.parent(), tree)) {
            return;
        }
        Iterator<Tree> iterator = ctx.ancestors().iterator();
        LinkedList<Token> nestedParentNodes = new LinkedList<Token>();
        Tree last = tree;
        while (iterator.hasNext()) {
            Tree parent = iterator.next();
            if (TooDeeplyNestedStatementsCheck.isElseIfStatement(parent, last) && !nestedParentNodes.isEmpty()) {
                nestedParentNodes.removeLast();
            }
            if (parent instanceof LoopTree || parent instanceof ExceptionHandlingTree || parent instanceof IfTree || parent instanceof MatchTree) {
                nestedParentNodes.addLast(TooDeeplyNestedStatementsCheck.getNodeToHighlight(parent));
            }
            if (nestedParentNodes.size() > this.max) {
                return;
            }
            last = parent;
        }
        if (nestedParentNodes.size() == this.max) {
            this.reportIssue(ctx, tree, nestedParentNodes);
        }
    }

    private static boolean isElseIfStatement(@Nullable Tree parent, @Nullable Tree tree) {
        return tree instanceof IfTree && parent instanceof IfTree && tree.equals(((IfTree)parent).elseBranch());
    }

    private void reportIssue(CheckContext ctx, Tree statement, Deque<Token> nestedStatements) {
        String message = "Refactor this code to not nest more than %s control flow statements.".formatted(this.max);
        ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>(nestedStatements.size());
        int nestedDepth = 0;
        while (!nestedStatements.isEmpty()) {
            String secondaryLocationMessage = String.format("Nesting depth %s", ++nestedDepth);
            secondaryLocations.add(new SecondaryLocation(nestedStatements.removeLast().textRange(), secondaryLocationMessage));
        }
        Token nodeToHighlight = TooDeeplyNestedStatementsCheck.getNodeToHighlight(statement);
        ctx.reportIssue((HasTextRange)nodeToHighlight, message, secondaryLocations);
    }

    private static Token getNodeToHighlight(Tree tree) {
        if (tree instanceof IfTree) {
            IfTree ifTree = (IfTree)tree;
            return ifTree.ifKeyword();
        }
        if (tree instanceof MatchTree) {
            MatchTree matchTree = (MatchTree)tree;
            return matchTree.keyword();
        }
        return ((LoopTree)tree).keyword();
    }
}

