/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.ParenthesizedExpressionTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.UnaryExpressionTree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1067")
public class TooComplexExpressionCheck
implements GoCheck {
    private static final int DEFAULT_MAX_COMPLEXITY = 3;
    @RuleProperty(key="max", description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    public int max = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(BinaryExpressionTree.class, (ctx, tree) -> {
            int complexity;
            if (TooComplexExpressionCheck.isParentExpression(ctx) && (complexity = TooComplexExpressionCheck.computeExpressionComplexity(tree)) > this.max) {
                String message = "Reduce the number of conditional operators (%s) used in the expression (maximum allowed %s).".formatted(complexity, this.max);
                double gap = (double)complexity - (double)this.max;
                ctx.reportIssue((HasTextRange)tree, message, Collections.emptyList(), gap);
            }
        });
    }

    private static boolean isParentExpression(CheckContext ctx) {
        for (Tree parentExpression : ctx.ancestors()) {
            if (parentExpression instanceof BinaryExpressionTree) {
                return false;
            }
            if (parentExpression instanceof UnaryExpressionTree && parentExpression instanceof ParenthesizedExpressionTree) continue;
            return true;
        }
        return true;
    }

    private static int computeExpressionComplexity(Tree originalTree) {
        Tree tree = ExpressionUtils.skipParentheses(originalTree);
        if (tree instanceof BinaryExpressionTree) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            int complexity = ExpressionUtils.isLogicalBinaryExpression(tree) ? 1 : 0;
            return complexity + TooComplexExpressionCheck.computeExpressionComplexity(binary.leftOperand()) + TooComplexExpressionCheck.computeExpressionComplexity(binary.rightOperand());
        }
        if (tree instanceof UnaryExpressionTree) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)tree;
            return TooComplexExpressionCheck.computeExpressionComplexity(unaryExpressionTree.operand());
        }
        return 0;
    }
}

