/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.MatchCaseTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
implements GoCheck {
    private static final int DEFAULT_MAX = 6;
    private static final String DEFAULT_MAX_VALUE = "6";
    private static final String MESSAGE = "Reduce this case clause number of lines from {0} to at most {1}, for example by extracting code into methods.";
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="6")
    public int max = 6;

    @Override
    public void initialize(InitContext init) {
        init.register(MatchCaseTree.class, (ctx, matchCaseTree) -> {
            int linesOfCode = matchCaseTree.metaData().linesOfCode().size();
            if (linesOfCode > this.max) {
                ctx.reportIssue(matchCaseTree.rangeToHighlight(), MessageFormat.format(MESSAGE, linesOfCode, this.max));
            }
        });
    }
}

