/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.StringLiteralTree;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
implements GoCheck {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 5;
    private static final Pattern NO_SEPARATOR_REGEXP = Pattern.compile("\\w++");
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            HashMap<String, List<StringLiteralTree>> occurrences = new HashMap<String, List<StringLiteralTree>>();
            tree.descendants().filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).filter(literal -> literal.content().length() > 5 && !NO_SEPARATOR_REGEXP.matcher(literal.content()).matches()).forEach(literal -> occurrences.computeIfAbsent(literal.content(), key -> new LinkedList()).add(literal));
            StringLiteralDuplicatedCheck.check(ctx, occurrences, this.threshold);
        });
    }

    private static void check(CheckContext ctx, Map<String, List<StringLiteralTree>> occurrencesMap, int threshold) {
        for (Map.Entry<String, List<StringLiteralTree>> entry : occurrencesMap.entrySet()) {
            List<StringLiteralTree> occurrences = entry.getValue();
            int size = occurrences.size();
            if (size < threshold) continue;
            StringLiteralTree first = occurrences.get(0);
            String message = "Define a constant instead of duplicating this literal \"%s\" %s times.".formatted(first.content(), size);
            List<SecondaryLocation> secondaryLocations = occurrences.stream().skip(1L).map(stringLiteral -> new SecondaryLocation(stringLiteral.metaData().textRange(), "Duplication")).toList();
            double gap = (double)size - 1.0;
            ctx.reportIssue(first, message, secondaryLocations, gap);
        }
    }
}

