/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.go.utils.NativeKinds;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S122")
public class OneStatementPerLineGoCheck
implements GoCheck {
    private static final String MESSAGE = "Reformat the code to have only one statement per line.";

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, topLevelTree) -> OneStatementPerLineGoCheck.checkStatements(ctx, topLevelTree.children()));
        init.register(BlockTree.class, (ctx, blockTree) -> OneStatementPerLineGoCheck.checkStatements(ctx, blockTree.statementOrExpressions()));
    }

    private static void checkStatements(CheckContext ctx, List<Tree> statementsOrExpressions) {
        statementsOrExpressions.stream().filter(tree -> !OneStatementPerLineGoCheck.shouldIgnore(tree)).collect(Collectors.groupingBy(OneStatementPerLineGoCheck::getLine)).forEach((line, statements) -> {
            if (statements.size() > 1) {
                OneStatementPerLineGoCheck.reportIssue(ctx, statements);
            }
        });
    }

    private static void reportIssue(CheckContext ctx, List<Tree> statements) {
        List<SecondaryLocation> secondaryLocations = statements.stream().skip(2L).map(statement -> new SecondaryLocation((Tree)statement, null)).toList();
        ctx.reportIssue((HasTextRange)statements.get(1), MESSAGE, secondaryLocations);
    }

    private static int getLine(Tree statementOrExpression) {
        return statementOrExpression.metaData().textRange().start().line();
    }

    private static boolean shouldIgnore(Tree tree) {
        return NativeKinds.isStringNativeKindOfType(tree, "Semicolon");
    }
}

