/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.go.utils.SyntacticEquivalence;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.IfTree;
import org.sonar.plugins.go.api.MatchCaseTree;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S1862")
public class IdenticalConditionsCheck
implements GoCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(MatchTree.class, (ctx, tree) -> IdenticalConditionsCheck.checkConditions(ctx, IdenticalConditionsCheck.collectConditions(tree)));
        init.register(IfTree.class, (ctx, tree) -> {
            if (!(ctx.parent() instanceof IfTree)) {
                IdenticalConditionsCheck.checkConditions(ctx, IdenticalConditionsCheck.collectConditions(tree, new ArrayList<Tree>()));
            }
        });
    }

    private static List<Tree> collectConditions(MatchTree matchTree) {
        return matchTree.cases().stream().map(MatchCaseTree::expression).filter(Objects::nonNull).map(ExpressionUtils::skipParentheses).toList();
    }

    private static List<Tree> collectConditions(IfTree ifTree, List<Tree> list) {
        list.add(ExpressionUtils.skipParentheses(ifTree.condition()));
        Tree elseBranch = ifTree.elseBranch();
        if (elseBranch instanceof IfTree) {
            IfTree elseIfBranch = (IfTree)elseBranch;
            return IdenticalConditionsCheck.collectConditions(elseIfBranch, list);
        }
        return list;
    }

    private static void checkConditions(CheckContext ctx, List<Tree> conditions) {
        for (List<Tree> group : SyntacticEquivalence.findDuplicatedGroups(conditions)) {
            Tree original = group.get(0);
            group.stream().skip(1L).forEach(duplicated -> {
                TextRange originalRange = original.metaData().textRange();
                ctx.reportIssue((HasTextRange)duplicated, "This condition duplicates the one on line " + originalRange.start().line() + ".", new SecondaryLocation(originalRange, "Original"));
            });
        }
    }
}

