/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.EnumSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.go.utils.SyntacticEquivalence;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S1764")
public class IdenticalBinaryOperandCheck
implements GoCheck {
    public static final String MESSAGE = "Correct one of the identical sub-expressions on both sides of this operator.";
    private static final Set<BinaryExpressionTree.Operator> EXCEPTIONS = EnumSet.of(BinaryExpressionTree.Operator.PLUS, BinaryExpressionTree.Operator.TIMES, BinaryExpressionTree.Operator.BITWISE_SHL);

    @Override
    public void initialize(InitContext init) {
        init.register(BinaryExpressionTree.class, (ctx, tree) -> {
            if (!EXCEPTIONS.contains((Object)tree.operator()) && !ExpressionUtils.containsPlaceHolder(tree) && SyntacticEquivalence.areEquivalent(ExpressionUtils.skipParentheses(tree.leftOperand()), ExpressionUtils.skipParentheses(tree.rightOperand()))) {
                ctx.reportIssue((HasTextRange)tree.rightOperand(), MESSAGE, new SecondaryLocation(tree.leftOperand()));
            }
        });
    }
}

