/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.go.checks.complexity.CognitiveComplexity;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S3776")
public class FunctionCognitiveComplexityCheck
implements GoCheck {
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    public int threshold = 15;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.name() == null) {
                return;
            }
            CognitiveComplexity complexity = new CognitiveComplexity((Tree)tree);
            if (complexity.value() > this.threshold) {
                String message = String.format("Refactor this method to reduce its Cognitive Complexity from %s to the %s allowed.", complexity.value(), this.threshold);
                List<SecondaryLocation> secondaryLocations = complexity.increments().stream().map(FunctionCognitiveComplexityCheck::secondaryLocation).toList();
                Double gap = (double)complexity.value() - (double)this.threshold;
                ctx.reportIssue(tree::rangeToHighlight, message, secondaryLocations, gap);
            }
        });
    }

    private static SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment) {
        int nestingLevel = increment.nestingLevel();
        String message = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message = message + " (incl " + nestingLevel + " for nesting)";
        }
        return new SecondaryLocation(increment.token().textRange(), message);
    }
}

