/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.TreeMetaData;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1186")
public class EmptyFunctionCheck
implements GoCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            BlockTree body = tree.body();
            if (body != null && body.statementOrExpressions().isEmpty() && !EmptyFunctionCheck.hasComment(body, ctx.parent().metaData())) {
                ctx.reportIssue(body, "Add a nested comment explaining why this function is empty or complete the implementation.");
            }
        });
    }

    private static boolean hasComment(BlockTree body, TreeMetaData parentMetaData) {
        if (!body.metaData().commentsInside().isEmpty()) {
            return true;
        }
        int emptyBodyEndLine = body.textRange().end().line();
        return parentMetaData.commentsInside().stream().anyMatch(comment -> comment.contentRange().start().line() == emptyBodyEndLine);
    }
}

