/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.LoopTree;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.NativeTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S108")
public class EmptyBlockCheck
implements GoCheck {
    private static final String MESSAGE = "Either remove or fill this block of code.";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, blockTree) -> {
            Tree parent = ctx.parent();
            if (EmptyBlockCheck.isValidBlock(parent) && blockTree.statementOrExpressions().isEmpty()) {
                EmptyBlockCheck.checkComments(ctx, blockTree);
            }
        });
        init.register(MatchTree.class, (ctx, matchTree) -> {
            if (matchTree.cases().isEmpty()) {
                EmptyBlockCheck.checkComments(ctx, matchTree);
            }
        });
    }

    private static boolean isValidBlock(@Nullable Tree parent) {
        return !(parent instanceof FunctionDeclarationTree) && !(parent instanceof NativeTree) && !EmptyBlockCheck.isWhileLoop(parent);
    }

    private static boolean isWhileLoop(@Nullable Tree parent) {
        LoopTree loopTree;
        return parent instanceof LoopTree && (loopTree = (LoopTree)parent).kind() == LoopTree.LoopKind.WHILE;
    }

    private static void checkComments(CheckContext ctx, Tree tree) {
        if (tree.metaData().commentsInside().isEmpty()) {
            ctx.reportIssue(tree, MESSAGE);
        }
    }
}

