/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.go.impl.TextRangeImpl;
import org.sonar.go.utils.TreeUtils;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionInvocationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.IfTree;
import org.sonar.plugins.go.api.JumpTree;
import org.sonar.plugins.go.api.ReturnTree;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
implements GoCheck {
    private static final String MESSAGE = "Add the missing \"else\" clause.";
    private static final Predicate<Tree> IS_IDENTIFIER_PANIC = tree -> {
        IdentifierTree identifierTree;
        return tree instanceof IdentifierTree && (identifierTree = (IdentifierTree)tree).name().equals("panic");
    };

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTree) -> {
            if (ifTree.elseBranch() == null || !ElseIfWithoutElseCheck.isTopLevelIf(ctx, ifTree)) {
                return;
            }
            IfTree prevTree = ifTree;
            boolean endsWithReturn = ElseIfWithoutElseCheck.endsWithReturnBreakOrPanic(ifTree);
            while (ifTree.elseBranch() instanceof IfTree) {
                prevTree = ifTree;
                ifTree = (IfTree)ifTree.elseBranch();
                endsWithReturn = endsWithReturn && ElseIfWithoutElseCheck.endsWithReturnBreakOrPanic(ifTree);
            }
            if (!endsWithReturn && ifTree.elseBranch() == null) {
                Token elseToken = prevTree.elseKeyword();
                Token ifToken = ifTree.ifKeyword();
                TextRangeImpl textRange = new TextRangeImpl(elseToken.textRange().start(), ifToken.textRange().end());
                ctx.reportIssue(textRange, MESSAGE);
            }
        });
    }

    private static boolean isTopLevelIf(CheckContext ctx, IfTree ifTree) {
        Tree firstAncestor = ctx.ancestors().getFirst();
        if (firstAncestor instanceof IfTree) {
            IfTree ifTreeAncestor = (IfTree)firstAncestor;
            return ifTreeAncestor.elseBranch() != ifTree;
        }
        return true;
    }

    private static boolean endsWithReturnBreakOrPanic(IfTree ifTree) {
        BlockTree blockTree;
        List<Tree> statements;
        Tree thenBranch = ifTree.thenBranch();
        if (thenBranch instanceof BlockTree && !(statements = (blockTree = (BlockTree)thenBranch).statementOrExpressions().stream().filter(TreeUtils.IS_NOT_SEMICOLON).toList()).isEmpty()) {
            Tree lastStmt = statements.get(statements.size() - 1);
            return ElseIfWithoutElseCheck.isReturnBreakOrPanic(lastStmt);
        }
        return ElseIfWithoutElseCheck.isReturnBreakOrPanic(thenBranch);
    }

    private static boolean isReturnBreakOrPanic(Tree tree) {
        return tree instanceof JumpTree || tree instanceof ReturnTree || ElseIfWithoutElseCheck.isPanicCall(tree);
    }

    private static boolean isPanicCall(Tree tree) {
        return Optional.of(tree).map(Tree::children).filter(children -> children.size() == 1).map(children -> (Tree)children.get(0)).filter(FunctionInvocationTree.class::isInstance).map(FunctionInvocationTree.class::cast).map(FunctionInvocationTree::memberSelect).filter(IS_IDENTIFIER_PANIC).isPresent();
    }
}

