/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.go.utils.SyntacticEquivalence;
import org.sonar.go.utils.TreeUtils;
import org.sonar.go.visitors.TreeContext;
import org.sonar.go.visitors.TreeVisitor;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.TopLevelTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S4144")
public class DuplicatedFunctionImplementationCheck
implements GoCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to \"%s\" on line %s.";
    private static final String MESSAGE_NO_NAME = "Update this function so that its implementation is not identical to the one on line %s.";
    private static final int MINIMUM_STATEMENTS_COUNT = 2;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            HashMap functionsByParents = new HashMap();
            TreeVisitor<TreeContext> functionVisitor = new TreeVisitor<TreeContext>();
            functionVisitor.register(FunctionDeclarationTree.class, (functionCtx, functionDeclarationTree) -> functionsByParents.computeIfAbsent(functionCtx.ancestors().peek(), key -> new ArrayList()).add(functionDeclarationTree));
            functionVisitor.scan(new TreeContext(), (Tree)tree);
            for (Map.Entry entry : functionsByParents.entrySet()) {
                DuplicatedFunctionImplementationCheck.check(ctx, (List)entry.getValue());
            }
        });
    }

    private static void check(CheckContext ctx, List<FunctionDeclarationTree> functionDeclarations) {
        HashSet reportedDuplicates = new HashSet();
        IntStream.range(0, functionDeclarations.size()).forEach(i -> {
            FunctionDeclarationTree original = (FunctionDeclarationTree)functionDeclarations.get(i);
            functionDeclarations.stream().skip((long)i + 1L).filter(f -> !reportedDuplicates.contains(f)).filter(DuplicatedFunctionImplementationCheck::hasMinimumSize).filter(f -> DuplicatedFunctionImplementationCheck.areDuplicatedImplementation(original, f)).forEach(duplicate -> {
                DuplicatedFunctionImplementationCheck.reportDuplicate(ctx, original, duplicate);
                reportedDuplicates.add(duplicate);
            });
        });
    }

    private static boolean hasMinimumSize(FunctionDeclarationTree function) {
        BlockTree functionBody = function.body();
        if (functionBody == null) {
            return false;
        }
        return functionBody.statementOrExpressions().stream().filter(TreeUtils.IS_NOT_SEMICOLON).count() >= 2L;
    }

    private static boolean areDuplicatedImplementation(FunctionDeclarationTree original, FunctionDeclarationTree possibleDuplicate) {
        return SyntacticEquivalence.areEquivalent(original.receiver(), possibleDuplicate.receiver()) && SyntacticEquivalence.areEquivalent(original.formalParameters(), possibleDuplicate.formalParameters()) && SyntacticEquivalence.areEquivalent(original.typeParameters(), possibleDuplicate.typeParameters()) && SyntacticEquivalence.areEquivalent(original.body(), possibleDuplicate.body());
    }

    private static void reportDuplicate(CheckContext ctx, FunctionDeclarationTree original, FunctionDeclarationTree duplicate) {
        String message;
        Tree secondaryTree;
        IdentifierTree identifier = original.name();
        int line = original.metaData().textRange().start().line();
        if (identifier != null) {
            secondaryTree = identifier;
            message = String.format(MESSAGE, identifier.name(), line);
        } else {
            secondaryTree = original;
            message = String.format(MESSAGE_NO_NAME, line);
        }
        SecondaryLocation secondaryLocation = new SecondaryLocation(secondaryTree, "original implementation");
        IdentifierTree duplicateIdentifier = duplicate.name();
        Tree primaryTree = duplicateIdentifier != null ? duplicateIdentifier : duplicate;
        ctx.reportIssue((HasTextRange)primaryTree, message, secondaryLocation);
    }
}

