/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.go.checks.AbstractBranchDuplicationCheck;
import org.sonar.go.utils.SyntacticEquivalence;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.MatchTree;
import org.sonar.plugins.go.api.TextRange;
import org.sonar.plugins.go.api.Token;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.SecondaryLocation;

@Rule(key="S1871")
public class DuplicateBranchGoCheck
extends AbstractBranchDuplicationCheck {
    @Override
    protected void checkDuplicatedBranches(CheckContext ctx, Tree tree, List<Tree> branches) {
        for (List<Tree> group : SyntacticEquivalence.findDuplicatedGroups(branches)) {
            Tree original = group.get(0);
            group.stream().skip(1L).filter(DuplicateBranchGoCheck::spansMultipleLines).forEach(duplicated -> {
                TextRange originalRange = original.metaData().textRange();
                ctx.reportIssue((HasTextRange)duplicated, "This branch's code block is the same as the block for the branch on line " + originalRange.start().line() + ".", new SecondaryLocation(originalRange, "Original"));
            });
        }
    }

    @Override
    protected void onAllIdenticalBranches(CheckContext ctx, Tree tree) {
    }

    protected static boolean spansMultipleLines(@Nullable Tree tree) {
        if (tree == null) {
            return false;
        }
        if (tree instanceof BlockTree) {
            BlockTree block = (BlockTree)tree;
            List<Tree> statements = block.statementOrExpressions();
            if (statements.isEmpty()) {
                return false;
            }
            Tree firstStatement = statements.get(0);
            Tree lastStatement = statements.get(statements.size() - 1);
            return firstStatement.metaData().textRange().start().line() != lastStatement.metaData().textRange().end().line();
        }
        TextRange range = tree.metaData().textRange();
        return range.start().line() < range.end().line();
    }

    @Override
    protected void checkConditionalStructure(CheckContext ctx, Tree tree, AbstractBranchDuplicationCheck.ConditionalStructure conditional) {
        MatchTree matchTree;
        if (tree instanceof MatchTree && DuplicateBranchGoCheck.isTypeSwitch(matchTree = (MatchTree)tree)) {
            return;
        }
        super.checkConditionalStructure(ctx, tree, conditional);
    }

    private static boolean isTypeSwitch(MatchTree matchTree) {
        Tree expression = matchTree.expression();
        return expression != null && DuplicateBranchGoCheck.endsWithTypeSwitchGuard(expression);
    }

    private static boolean endsWithTypeSwitchGuard(Tree matchTreeExpression) {
        List<Token> tokens = matchTreeExpression.metaData().tokens();
        int size = tokens.size();
        return size >= 4 && tokens.subList(size - 4, size).stream().map(Token::text).collect(Collectors.joining("")).equals(".(type)");
    }
}

