/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.go.utils.NativeKinds;
import org.sonar.plugins.go.api.BlockTree;
import org.sonar.plugins.go.api.HasKeyword;
import org.sonar.plugins.go.api.JumpTree;
import org.sonar.plugins.go.api.ReturnTree;
import org.sonar.plugins.go.api.ThrowTree;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.checks.CheckContext;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1763")
public class CodeAfterJumpGoCheck
implements GoCheck {
    private static final String MESSAGE = "Refactor this piece of code to not have any dead code after this \"%s\".";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, blockTree) -> CodeAfterJumpGoCheck.checkStatements(ctx, blockTree.statementOrExpressions()));
    }

    private static void checkStatements(CheckContext ctx, List<Tree> statementsOrExpressions) {
        if (statementsOrExpressions.size() < 2) {
            return;
        }
        int index = 0;
        while (index < statementsOrExpressions.size() - 1) {
            Tree current = statementsOrExpressions.get(index);
            Tree next = statementsOrExpressions.get(++index);
            while (index < statementsOrExpressions.size() && CodeAfterJumpGoCheck.shouldIgnore(next)) {
                next = statementsOrExpressions.get(index);
                ++index;
            }
            if (!CodeAfterJumpGoCheck.isJump(current) || CodeAfterJumpGoCheck.shouldIgnore(next) || CodeAfterJumpGoCheck.isValidAfterJump(next)) continue;
            ctx.reportIssue(current, String.format(MESSAGE, ((HasKeyword)((Object)current)).keyword().text()));
        }
    }

    private static boolean isJump(Tree tree) {
        return tree instanceof JumpTree || tree instanceof ReturnTree || tree instanceof ThrowTree;
    }

    private static boolean isValidAfterJump(Tree tree) {
        return NativeKinds.isStringNativeKind(tree, str -> str.contains("LabeledStmt"));
    }

    private static boolean shouldIgnore(Tree tree) {
        return NativeKinds.isStringNativeKindOfType(tree, "Semicolon");
    }
}

