/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.UnaryExpressionTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1125")
public class BooleanLiteralCheck
implements GoCheck {
    private static final List<BinaryExpressionTree.Operator> CONDITIONAL_BINARY_OPERATORS = Arrays.asList(BinaryExpressionTree.Operator.CONDITIONAL_AND, BinaryExpressionTree.Operator.CONDITIONAL_OR);
    private static final String MESSAGE = "Remove the unnecessary Boolean literal.";

    @Override
    public void initialize(InitContext init) {
        init.register(BinaryExpressionTree.class, (ctx, binaryExprTree) -> {
            if (CONDITIONAL_BINARY_OPERATORS.contains((Object)binaryExprTree.operator())) {
                BooleanLiteralCheck.getBooleanLiteral(binaryExprTree.leftOperand(), binaryExprTree.rightOperand()).ifPresent(booleanLiteral -> ctx.reportIssue((HasTextRange)booleanLiteral, MESSAGE));
            }
        });
        init.register(UnaryExpressionTree.class, (ctx, unaryExprTree) -> {
            if (UnaryExpressionTree.Operator.NEGATE.equals((Object)unaryExprTree.operator())) {
                BooleanLiteralCheck.getBooleanLiteral(unaryExprTree.operand()).ifPresent(booleanLiteral -> ctx.reportIssue((HasTextRange)booleanLiteral, MESSAGE));
            }
        });
    }

    private static Optional<Tree> getBooleanLiteral(Tree ... trees) {
        return Arrays.stream(trees).map(ExpressionUtils::skipParentheses).filter(ExpressionUtils::isBooleanLiteral).findFirst();
    }
}

