/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.EnumMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.go.utils.ExpressionUtils;
import org.sonar.plugins.go.api.BinaryExpressionTree;
import org.sonar.plugins.go.api.HasTextRange;
import org.sonar.plugins.go.api.Tree;
import org.sonar.plugins.go.api.UnaryExpressionTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S1940")
public class BooleanInversionCheck
implements GoCheck {
    private static final Map<BinaryExpressionTree.Operator, String> OPERATORS = BooleanInversionCheck.createOperatorsMap();

    private static Map<BinaryExpressionTree.Operator, String> createOperatorsMap() {
        EnumMap<BinaryExpressionTree.Operator, String> operatorsMap = new EnumMap<BinaryExpressionTree.Operator, String>(BinaryExpressionTree.Operator.class);
        operatorsMap.put(BinaryExpressionTree.Operator.EQUAL_TO, "!=");
        operatorsMap.put(BinaryExpressionTree.Operator.NOT_EQUAL_TO, "==");
        operatorsMap.put(BinaryExpressionTree.Operator.LESS_THAN, ">=");
        operatorsMap.put(BinaryExpressionTree.Operator.GREATER_THAN, "<=");
        operatorsMap.put(BinaryExpressionTree.Operator.LESS_THAN_OR_EQUAL_TO, ">");
        operatorsMap.put(BinaryExpressionTree.Operator.GREATER_THAN_OR_EQUAL_TO, "<");
        return operatorsMap;
    }

    @Override
    public void initialize(InitContext init) {
        init.register(UnaryExpressionTree.class, (ctx, tree) -> {
            BinaryExpressionTree binaryExpression;
            String oppositeOperator;
            Tree innerExpression = ExpressionUtils.skipParentheses(tree.operand());
            if (tree.operator() == UnaryExpressionTree.Operator.NEGATE && innerExpression instanceof BinaryExpressionTree && (oppositeOperator = OPERATORS.get((Object)(binaryExpression = (BinaryExpressionTree)innerExpression).operator())) != null) {
                String message = String.format("Use the opposite operator (\"%s\") instead.", oppositeOperator);
                ctx.reportIssue((HasTextRange)tree, message);
            }
        });
    }
}

