/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.go.api.FunctionDeclarationTree;
import org.sonar.plugins.go.api.IdentifierTree;
import org.sonar.plugins.go.api.checks.GoCheck;
import org.sonar.plugins.go.api.checks.InitContext;

@Rule(key="S100")
public class BadFunctionNameCheck
implements GoCheck {
    @RuleProperty(key="format", description="Regular expression used to check the function names against.", defaultValue="^(_|[a-zA-Z0-9]+)$")
    public String format = "^(_|[a-zA-Z0-9]+)$";

    private String message(String name) {
        return "Rename function \"" + name + "\" to match the regular expression " + this.format;
    }

    @Override
    public void initialize(InitContext init) {
        Pattern pattern = Pattern.compile(this.format);
        init.register(FunctionDeclarationTree.class, (ctx, fnDeclarationTree) -> {
            IdentifierTree name = fnDeclarationTree.name();
            if (name != null && !pattern.matcher(name.name()).matches()) {
                ctx.reportIssue(name, this.message(name.name()));
            }
        });
    }
}

