/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.util.Objects;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;

public class RLikePattern
extends AbstractStringPattern {
    private final String regexpPattern;

    public RLikePattern(String regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    @Override
    public Automaton createAutomaton(boolean ignoreCase) {
        int matchFlags = ignoreCase ? 256 : 0;
        return Operations.determinize((Automaton)new RegExp(this.regexpPattern, 255, matchFlags).toAutomaton(), (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.regexpPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RLikePattern that = (RLikePattern)o;
        return Objects.equals(this.regexpPattern, that.regexpPattern);
    }

    public int hashCode() {
        return Objects.hash(this.regexpPattern);
    }

    @Override
    public String pattern() {
        return this.regexpPattern;
    }
}

