/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.function.scalar;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public abstract class BinaryScalarFunction
extends ScalarFunction {
    private final Expression left;
    private final Expression right;

    protected BinaryScalarFunction(Source source, Expression left, Expression right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    protected BinaryScalarFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left);
        out.writeNamedWriteable((NamedWriteable)this.right);
    }

    @Override
    public final BinaryScalarFunction replaceChildren(List<Expression> newChildren) {
        Expression newLeft = newChildren.get(0);
        Expression newRight = newChildren.get(1);
        return this.left.equals(newLeft) && this.right.equals(newRight) ? this : this.replaceChildren(newLeft, newRight);
    }

    protected abstract BinaryScalarFunction replaceChildren(Expression var1, Expression var2);

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public boolean foldable() {
        return this.left.foldable() && this.right.foldable();
    }
}

