/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;
import org.sonarsource.analyzer.commons.EducationRuleLoader;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKeys;
import org.sonarsource.analyzer.commons.domain.RuleManifest;
import org.sonarsource.analyzer.commons.domain.RuleManifestCode;
import org.sonarsource.analyzer.commons.domain.RuleManifestParameter;
import org.sonarsource.analyzer.commons.domain.RuleManifestRemediation;

public class RuleMetadataLoader {
    private static final String INVALID_PROPERTY_MESSAGE = "Invalid property: %s";
    private static final char RESOURCE_SEP = '/';
    private final String resourceFolder;
    private final Set<String> activatedByDefault;
    private final JsonParser jsonParser;
    private final SonarRuntime sonarRuntime;
    private final EducationRuleLoader educationRuleLoader;
    private static final String OWASP_MOBILE_2024 = "OWASP Mobile Top 10 2024";
    private static final String OWASP_2025 = "OWASP Top 10 2025";
    private static final String OWASP_2021 = "OWASP Top 10 2021";
    private static final String OWASP_2017 = "OWASP";
    private static final String PCI_DSS_PREFIX = "PCI DSS ";
    private static final String ASVS_PREFIX = "ASVS ";
    private static final String STIG_PREFIX = "STIG ";
    private static final String IMPACTS = "impacts";
    private static final String LINEAR_FACTOR = "linearFactor";
    private static final String LINEAR_DESCRIPTION = "linearDesc";

    public RuleMetadataLoader(SonarRuntime sonarRuntime) {
        this(null, Collections.emptySet(), sonarRuntime);
    }

    public RuleMetadataLoader(String resourceFolder, SonarRuntime sonarRuntime) {
        this(resourceFolder, Collections.emptySet(), sonarRuntime);
    }

    public RuleMetadataLoader(String resourceFolder, String defaultProfilePath, SonarRuntime sonarRuntime) {
        this(resourceFolder, BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(defaultProfilePath), sonarRuntime);
    }

    private RuleMetadataLoader(@Nullable String resourceFolder, Set<String> activatedByDefault, SonarRuntime sonarRuntime) {
        this.resourceFolder = resourceFolder;
        this.jsonParser = new JsonParser();
        this.activatedByDefault = activatedByDefault;
        this.sonarRuntime = sonarRuntime;
        this.educationRuleLoader = new EducationRuleLoader(sonarRuntime);
    }

    public void addRulesByAnnotatedClass(RulesDefinition.NewRepository repository, List<Class<?>> ruleClasses) {
        for (Class<?> ruleClass : ruleClasses) {
            this.addRuleByAnnotatedClass(repository, ruleClass);
        }
    }

    public void addRulesByRuleKey(RulesDefinition.NewRepository repository, List<String> ruleKeys) {
        for (String ruleKey : ruleKeys) {
            this.addRuleByRuleKey(repository, ruleKey);
        }
    }

    private void addRuleByAnnotatedClass(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        RulesDefinition.NewRule rule = RuleMetadataLoader.addAnnotatedRule(repository, ruleClass);
        this.setDescriptionFromHtmlFile(rule);
        this.setMetadataFromJsonFile(rule);
        this.setDefaultActivation(rule);
    }

    private void setDefaultActivation(RulesDefinition.NewRule rule) {
        if (this.activatedByDefault.contains(rule.key())) {
            rule.setActivatedByDefault(true);
        }
    }

    private static RulesDefinition.NewRule addAnnotatedRule(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalStateException("No Rule annotation was found on " + ruleClass.getName());
        }
        String ruleKey = ruleAnnotation.key();
        if (ruleKey.isEmpty()) {
            throw new IllegalStateException("Empty key");
        }
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, new Class[]{ruleClass});
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("Rule not found: " + ruleKey);
        }
        DeprecatedRuleKeys deprecatedRuleKeys = (DeprecatedRuleKeys)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKeys.class);
        if (deprecatedRuleKeys != null) {
            Arrays.stream(deprecatedRuleKeys.value()).forEach(deprecatedRuleKey -> RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey));
        } else {
            DeprecatedRuleKey deprecatedRuleKey2 = (DeprecatedRuleKey)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKey.class);
            if (deprecatedRuleKey2 != null) {
                RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey2);
            }
        }
        return rule;
    }

    private static void addDeprecatedRuleKey(RulesDefinition.NewRepository repository, RulesDefinition.NewRule rule, DeprecatedRuleKey deprecatedRuleKey) {
        String repoKey = deprecatedRuleKey.repositoryKey().isEmpty() ? repository.key() : deprecatedRuleKey.repositoryKey();
        rule.addDeprecatedRuleKey(repoKey, deprecatedRuleKey.ruleKey());
    }

    private void addRuleByRuleKey(RulesDefinition.NewRepository repository, String ruleKey) {
        if (ruleKey.isEmpty()) {
            throw new IllegalStateException("Empty key");
        }
        RulesDefinition.NewRule rule = repository.createRule(ruleKey);
        this.setDescriptionFromHtmlFile(rule);
        this.setMetadataFromJsonFile(rule);
        this.setDefaultActivation(rule);
    }

    private void setDescriptionFromHtml(RulesDefinition.NewRule rule, String description) {
        description = this.educationRuleLoader.setEducationDescriptionFromHtml(rule, description);
        rule.setHtmlDescription(description);
    }

    private void setDescriptionFromHtmlFile(RulesDefinition.NewRule rule) {
        String description;
        String htmlPath = this.resourceFolder + "/" + rule.key() + ".html";
        try {
            description = Resources.toString(htmlPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + htmlPath, e);
        }
        this.setDescriptionFromHtml(rule, description);
    }

    private void setMetadataFromJson(RulesDefinition.NewRule rule, Map<String, Object> ruleMetadata) {
        Object securityStandards;
        Object code;
        rule.setName(RuleMetadataLoader.getString(ruleMetadata, "title"));
        rule.setSeverity(RuleMetadataLoader.getUpperCaseString(ruleMetadata, "defaultSeverity"));
        String type = RuleMetadataLoader.getUpperCaseString(ruleMetadata, "type");
        rule.setType(RuleType.valueOf((String)type));
        if (this.isSupported(10, 1) && (code = ruleMetadata.get("code")) != null) {
            this.setCodeAttributeFromJson(rule, (Map)code);
        }
        rule.setStatus(RuleStatus.valueOf((String)RuleMetadataLoader.getUpperCaseString(ruleMetadata, "status")));
        rule.setTags(RuleMetadataLoader.getStringArray(ruleMetadata, "tags"));
        RuleMetadataLoader.getScopeIfPresent(ruleMetadata, "scope").ifPresent(arg_0 -> ((RulesDefinition.NewRule)rule).setScope(arg_0));
        Object remediation = ruleMetadata.get("remediation");
        if (remediation != null) {
            RuleMetadataLoader.setRemediationFromJson(rule, (Map)remediation);
        }
        if ((securityStandards = ruleMetadata.get("securityStandards")) != null) {
            this.setSecurityStandardsFromJson(rule, (Map)securityStandards);
        }
        this.educationRuleLoader.setEducationMetadataFromJson(rule, ruleMetadata);
    }

    private void setMetadataFromJsonFile(RulesDefinition.NewRule rule) {
        Map<String, Object> ruleMetadata = this.getMetadataFromFile(rule.key());
        this.setMetadataFromJson(rule, ruleMetadata);
    }

    Map<String, Object> getMetadataFromFile(String ruleKey) {
        String jsonPath = this.resourceFolder + "/" + ruleKey + ".json";
        try {
            return this.jsonParser.parse(Resources.toString(jsonPath, StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Can't read resource: " + jsonPath, e);
        }
    }

    private void setCodeAttributeFromJson(RulesDefinition.NewRule rule, Map<String, Object> code) {
        String attribute = RuleMetadataLoader.getString(code, "attribute");
        rule.setCleanCodeAttribute(CleanCodeAttribute.valueOf((String)attribute));
        Map impacts = (Map)code.get(IMPACTS);
        if (impacts == null || impacts.isEmpty()) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, IMPACTS) + " for rule: " + rule.key());
        }
        impacts.forEach((softwareQuality, severity) -> rule.addDefaultImpact(SoftwareQuality.valueOf((String)softwareQuality), this.getCleanCodeTaxanomySeverity((String)severity)));
    }

    private Severity getCleanCodeTaxanomySeverity(String severity) {
        if (this.isSupported(10, 11)) {
            return Severity.valueOf((String)severity);
        }
        switch (severity) {
            case "INFO": {
                return Severity.LOW;
            }
            case "BLOCKER": {
                return Severity.HIGH;
            }
        }
        return Severity.valueOf((String)severity);
    }

    private void setSecurityStandardsFromJson(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (securityStandards.get("CWE") != null) {
            rule.addCwe(RuleMetadataLoader.getIntArray(securityStandards, "CWE"));
        }
        this.addMasvs(rule, securityStandards);
        this.addOwasp(rule, securityStandards);
        this.addOwaspAsvs(rule, securityStandards);
        this.addOwaspLlm(rule, securityStandards);
        this.addOwaspMobile(rule, securityStandards);
        this.addPciDss(rule, securityStandards);
        this.addStig(rule, securityStandards);
    }

    private void addMasvs(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(13, 3)) {
            return;
        }
        for (RulesDefinition.MasvsVersion masvsVersion : RulesDefinition.MasvsVersion.values()) {
            rule.addMasvs(masvsVersion, RuleMetadataLoader.getStringArray(securityStandards, masvsVersion.label()));
        }
    }

    private void addOwasp(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        boolean isOwaspByVersionSupported = this.isSupported(9, 3);
        RulesDefinition.OwaspTop10[] valuesFor2017 = this.getOwaspTop10Values(securityStandards, OWASP_2017);
        if (isOwaspByVersionSupported) {
            rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2017, valuesFor2017);
            RulesDefinition.OwaspTop10[] valuesFor2021 = this.getOwaspTop10Values(securityStandards, OWASP_2021);
            rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2021, valuesFor2021);
            if (this.isSupported(13, 3)) {
                RulesDefinition.OwaspTop10[] valuesFor2025 = this.getOwaspTop10Values(securityStandards, OWASP_2025);
                rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2025, valuesFor2025);
            }
        } else {
            rule.addOwaspTop10(valuesFor2017);
        }
    }

    private RulesDefinition.OwaspTop10[] getOwaspTop10Values(Map<String, Object> securityStandards, String owaspVersionLabel) {
        return (RulesDefinition.OwaspTop10[])Arrays.stream(RuleMetadataLoader.getStringArray(securityStandards, owaspVersionLabel)).map(RulesDefinition.OwaspTop10::valueOf).toArray(RulesDefinition.OwaspTop10[]::new);
    }

    private void addOwaspMobile(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(11, 4)) {
            return;
        }
        for (String standard : RuleMetadataLoader.getStringArray(securityStandards, OWASP_MOBILE_2024)) {
            rule.addOwaspMobileTop10(RulesDefinition.OwaspMobileTop10Version.Y2024, new RulesDefinition.OwaspMobileTop10[]{RulesDefinition.OwaspMobileTop10.valueOf((String)standard)});
        }
    }

    private void addOwaspLlm(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(13, 3)) {
            return;
        }
        for (RulesDefinition.OwaspLlmTop10Version owaspLlmTop10Version : RulesDefinition.OwaspLlmTop10Version.values()) {
            RulesDefinition.OwaspLlmTop10[] llmTop10Values = (RulesDefinition.OwaspLlmTop10[])Arrays.stream(RuleMetadataLoader.getStringArray(securityStandards, owaspLlmTop10Version.label())).map(RulesDefinition.OwaspLlmTop10::valueOf).toArray(RulesDefinition.OwaspLlmTop10[]::new);
            rule.addOwaspLlmTop10(owaspLlmTop10Version, llmTop10Values);
        }
    }

    private void addPciDss(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(9, 5)) {
            return;
        }
        for (RulesDefinition.PciDssVersion pciDssVersion : RulesDefinition.PciDssVersion.values()) {
            String pciDssKey = PCI_DSS_PREFIX + pciDssVersion.label();
            rule.addPciDss(pciDssVersion, RuleMetadataLoader.getStringArray(securityStandards, pciDssKey));
        }
    }

    private void addOwaspAsvs(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(9, 9)) {
            return;
        }
        for (RulesDefinition.OwaspAsvsVersion asvsVersion : RulesDefinition.OwaspAsvsVersion.values()) {
            String asvsKey = ASVS_PREFIX + asvsVersion.label();
            rule.addOwaspAsvs(asvsVersion, RuleMetadataLoader.getStringArray(securityStandards, asvsKey));
        }
    }

    private void addStig(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (!this.isSupported(10, 10)) {
            return;
        }
        for (RulesDefinition.StigVersion stigVersion : RulesDefinition.StigVersion.values()) {
            String stigKey = STIG_PREFIX + stigVersion.label();
            rule.addStig(stigVersion, RuleMetadataLoader.getStringArray(securityStandards, stigKey));
        }
    }

    private boolean isSupported(int minMajor, int minMinor) {
        return this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)minMajor, (int)minMinor));
    }

    private static void setRemediationFromJson(RulesDefinition.NewRule rule, Map<String, Object> remediation) {
        String func = RuleMetadataLoader.getString(remediation, "func");
        RulesDefinition.DebtRemediationFunctions remediationBuilder = rule.debtRemediationFunctions();
        if (func.startsWith("Constant")) {
            String constantCost = RuleMetadataLoader.getString(remediation, "constantCost");
            rule.setDebtRemediationFunction(remediationBuilder.constantPerIssue(constantCost.replace("mn", "min")));
        } else if ("Linear".equals(func)) {
            String linearFactor = RuleMetadataLoader.getString(remediation, LINEAR_FACTOR);
            rule.setDebtRemediationFunction(remediationBuilder.linear(linearFactor.replace("mn", "min")));
        } else {
            String linearFactor = RuleMetadataLoader.getString(remediation, LINEAR_FACTOR);
            String linearOffset = RuleMetadataLoader.getString(remediation, "linearOffset");
            rule.setDebtRemediationFunction(remediationBuilder.linearWithOffset(linearFactor.replace("mn", "min"), linearOffset.replace("mn", "min")));
        }
        if (remediation.get(LINEAR_DESCRIPTION) != null) {
            rule.setGapDescription(RuleMetadataLoader.getString(remediation, LINEAR_DESCRIPTION));
        }
    }

    private static String getUpperCaseString(Map<String, Object> map, String propertyName) {
        return RuleMetadataLoader.getString(map, propertyName).toUpperCase(Locale.ROOT);
    }

    private static String getString(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof String)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return (String)propertyValue;
    }

    static String[] getStringArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (propertyValue == null) {
            return new String[0];
        }
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).toArray(new String[0]);
    }

    static Optional<RuleScope> getScopeIfPresent(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        return Optional.ofNullable(propertyValue).filter(String.class::isInstance).map(value -> ((String)value).toUpperCase(Locale.ROOT)).map(scope -> "TESTS".equals(scope) ? "TEST" : scope).map(RuleScope::valueOf);
    }

    private static int[] getIntArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).stream().mapToInt(Number::intValue).toArray();
    }

    public RulesDefinition.NewRule createRuleFromRuleManifest(RulesDefinition.NewRepository repository, RuleManifest ruleManifest) {
        RulesDefinition.NewRule newRule = repository.createRule(ruleManifest.name());
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> remediationMap = new HashMap<String, String>();
        RuleManifestRemediation remediation = ruleManifest.remediation();
        if (remediation != null) {
            remediationMap.put("func", remediation.func());
            remediationMap.put("constantCost", remediation.constantCost());
            remediationMap.put(LINEAR_DESCRIPTION, remediation.linearDescription());
            remediationMap.put(LINEAR_FACTOR, remediation.linearFactor());
            remediationMap.put("linearOffset", remediation.linearOffset());
            map.put("remediation", remediationMap);
        }
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        RuleManifestCode code = ruleManifest.code();
        if (code != null) {
            codeMap.put(IMPACTS, code.impacts());
            codeMap.put("attribute", code.attribute());
            map.put("code", codeMap);
        }
        map.put("defaultSeverity", ruleManifest.defaultSeverity());
        map.put("scope", ruleManifest.scope());
        map.put("status", ruleManifest.status());
        map.put("tags", ruleManifest.tags());
        map.put("title", ruleManifest.title());
        map.put("type", ruleManifest.type());
        this.setMetadataFromJson(newRule, map);
        this.setDescriptionFromHtml(newRule, ruleManifest.htmlDocumentation());
        for (RuleManifestParameter parameter : ruleManifest.parameters()) {
            newRule.createParam(parameter.name()).setName(parameter.name()).setDescription(parameter.description()).setDefaultValue(parameter.defaultValue()).setType(RuleParamType.parse((String)parameter.type()));
        }
        return newRule;
    }
}

