/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressReport
implements Runnable {
    private final long period;
    private final Consumer<String> logger;
    private long count;
    private long currentFileNumber = -1L;
    private String currentFilename;
    private final Thread thread;
    private final String adjective;
    private final AtomicBoolean success = new AtomicBoolean(false);
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public ProgressReport(String threadName, long period, Consumer<String> logger, String adjective) {
        this.interrupted.set(false);
        this.period = period;
        this.logger = logger;
        this.adjective = adjective;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
    }

    public ProgressReport(String threadName, long period, Logger logger, String adjective) {
        this(threadName, period, logger::info, adjective);
    }

    public ProgressReport(String threadName, long period, String adjective) {
        this(threadName, period, LoggerFactory.getLogger(ProgressReport.class), adjective);
    }

    public ProgressReport(String threadName, long period) {
        this(threadName, period, "analyzed");
    }

    @Override
    public void run() {
        this.log(this.count + " source " + ProgressReport.pluralizeFile(this.count) + " to be " + this.adjective);
        while (!this.interrupted.get() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.period);
                this.log(this.currentFileNumber + "/" + this.count + " " + ProgressReport.pluralizeFile(this.currentFileNumber) + " " + this.adjective + ", current file: " + this.currentFilename);
            }
            catch (InterruptedException e) {
                this.interrupted.set(true);
                this.thread.interrupt();
                break;
            }
        }
        if (this.success.get()) {
            this.log(this.count + "/" + this.count + " source " + ProgressReport.pluralizeFile(this.count) + " " + ProgressReport.pluralizeHas(this.count) + " been " + this.adjective);
        }
    }

    private static String pluralizeFile(long count) {
        if (count == 1L) {
            return "file";
        }
        return "files";
    }

    private static String pluralizeHas(long count) {
        if (count == 1L) {
            return "has";
        }
        return "have";
    }

    public synchronized void start(long count, String currentFilename) {
        this.count = count;
        this.nextFile(currentFilename);
        this.thread.start();
    }

    public synchronized void nextFile(String currentFilename) {
        ++this.currentFileNumber;
        this.currentFilename = currentFilename;
    }

    public synchronized void stop() {
        this.success.set(true);
        this.interrupted.set(true);
        this.thread.interrupt();
        this.join();
    }

    public synchronized void cancel() {
        this.interrupted.set(true);
        this.thread.interrupt();
        this.join();
    }

    private void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void log(String message) {
        this.logger.accept(message);
    }
}

