/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PathWalker
implements Iterator<Path> {
    private final Deque<Path> paths = new ArrayDeque<Path>();
    private final long rootDepth;
    private final int maxDepth;
    private final Predicate<Path> exclusion;

    private PathWalker(Path root, int maxDepth, Predicate<Path> exclusion) {
        this.rootDepth = PathWalker.depth(root);
        this.maxDepth = Math.max(0, maxDepth);
        this.exclusion = exclusion;
        this.addPath(root);
    }

    public static Stream<Path> stream(Path root, int maxDepth) {
        return PathWalker.stream(root, maxDepth, p -> false);
    }

    public static Stream<Path> stream(Path root, int maxDepth, Predicate<Path> exclusion) {
        PathWalker pathWalker = new PathWalker(root, maxDepth, exclusion);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(pathWalker, 16), false);
    }

    private static long depth(Path path) {
        return StreamSupport.stream(path.spliterator(), false).count();
    }

    @Override
    public boolean hasNext() {
        return !this.paths.isEmpty();
    }

    @Override
    public Path next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Path path = this.paths.removeFirst();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream.ofNullable(path.toFile().listFiles()).flatMap(Arrays::stream).map(File::toPath).filter(p -> !this.exclusion.test((Path)p)).forEach(this::addPath);
        }
        return path;
    }

    private void addPath(Path path) {
        if (!Files.isSymbolicLink(path) && !this.isTooDeep(path)) {
            this.paths.addFirst(path);
        }
    }

    private boolean isTooDeep(Path path) {
        long pathDepth = PathWalker.depth(path);
        return pathDepth - this.rootDepth > (long)this.maxDepth;
    }
}

