/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.sonarlint;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.javascript.sonarlint.FSListener;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileEvent;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener;

@SonarLintSide(lifespan="MODULE")
public class FSListenerImpl
implements FSListener,
ModuleFileListener {
    private static final Logger LOG = LoggerFactory.getLogger(FSListenerImpl.class);
    Map<String, String> changedFilesMap = new HashMap<String, String>();

    @Override
    public Map<String, String> listFSEvents() {
        HashMap<String, String> result = new HashMap<String, String>(this.changedFilesMap);
        this.changedFilesMap.clear();
        return result;
    }

    public void process(ModuleFileEvent moduleFileEvent) {
        InputFile file = moduleFileEvent.getTarget();
        String filename = file.absolutePath();
        LOG.debug("Processing file event {} with event {}", (Object)filename, (Object)moduleFileEvent.getType());
        this.changedFilesMap.put(filename, moduleFileEvent.getType().name());
    }
}

