/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.rules;

import java.util.HashMap;
import java.util.Map;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class EslintRulesDefinition
implements RulesDefinition {
    public static final String REPOSITORY_KEY = "eslint_repo";
    public static final String LINTER_NAME = "ESLint";
    private static final String[] ESLINT_PLUGINS = new String[]{"@angular-eslint", "@angular-eslint-template", "@typescript-eslint", "angular", "core", "ember", "flowtype", "import", "jsx-a11y", "node", "promise", "react", "react-hooks", "sonarjs", "vue"};
    private static final Map<String, ExternalRuleLoader> RULE_LOADERS = new HashMap<String, ExternalRuleLoader>();

    public void define(RulesDefinition.Context context) {
        RULE_LOADERS.forEach((s, externalRuleLoader) -> externalRuleLoader.createExternalRuleRepository(context));
    }

    public static ExternalRuleLoader loader(String eslintKey) {
        if (eslintKey.contains("/")) {
            String[] keyParts = eslintKey.split("/");
            Object pluginName = keyParts[0];
            if (keyParts.length > 2) {
                pluginName = keyParts[0] + "-" + keyParts[1];
            }
            if (RULE_LOADERS.containsKey(pluginName)) {
                return RULE_LOADERS.get(pluginName);
            }
        }
        return RULE_LOADERS.get("core");
    }

    static {
        for (String plugin : ESLINT_PLUGINS) {
            RULE_LOADERS.put(plugin, new ExternalRuleLoader(REPOSITORY_KEY, LINTER_NAME, "org/sonar/l10n/javascript/rules/eslint/" + plugin + ".json", "js"));
        }
    }
}

