/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.nodejs;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.sonar.plugins.javascript.nodejs.ProcessWrapper;
import org.sonar.plugins.javascript.nodejs.StreamConsumer;

public class ProcessWrapperImpl
implements ProcessWrapper {
    private StreamConsumer streamConsumer;

    @Override
    public Process startProcess(List<String> commandLine, Map<String, String> env, Consumer<String> outputConsumer, Consumer<String> errorConsumer) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().putAll(env);
        Process process = processBuilder.start();
        this.streamConsumer = new StreamConsumer();
        this.streamConsumer.consumeStream(process.getInputStream(), outputConsumer);
        this.streamConsumer.consumeStream(process.getErrorStream(), errorConsumer);
        return process;
    }

    @Override
    public boolean waitFor(Process process, long timeout, TimeUnit unit) throws InterruptedException {
        boolean waitFor = process.waitFor(timeout, unit);
        this.streamConsumer.await();
        return waitFor;
    }

    @Override
    public void interrupt() {
        Thread.currentThread().interrupt();
    }

    @Override
    public void destroyForcibly(Process process) {
        process.destroyForcibly();
    }

    @Override
    public boolean isMac() {
        return ProcessWrapperImpl.getOsName().startsWith("mac");
    }

    @Override
    public boolean isWindows() {
        return ProcessWrapperImpl.getOsName().startsWith("windows");
    }

    private static String getOsName() {
        return System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
    }

    @Override
    @CheckForNull
    public String getenv(String name) {
        return System.getenv(name);
    }

    @Override
    public int exitValue(Process process) {
        return process.exitValue();
    }
}

