/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.nodejs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.Version;
import org.sonar.plugins.javascript.nodejs.NodeCommandException;
import org.sonar.plugins.javascript.nodejs.ProcessWrapper;

public class NodeCommand {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCommand.class);
    final Consumer<String> outputConsumer;
    final Consumer<String> errorConsumer;
    private final ProcessWrapper processWrapper;
    private final Version actualNodeVersion;
    private final Map<String, String> env;
    private Process process;
    private final List<String> command;
    private final String nodeExecutableOrigin;

    NodeCommand(ProcessWrapper processWrapper, String nodeExecutable, Version actualNodeVersion, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args, Consumer<String> outputConsumer, Consumer<String> errorConsumer, Map<String, String> env, String nodeExecutableOrigin) {
        this.processWrapper = processWrapper;
        this.command = NodeCommand.buildCommand(nodeExecutable, nodeJsArgs, scriptFilename, args);
        this.actualNodeVersion = actualNodeVersion;
        this.outputConsumer = outputConsumer;
        this.errorConsumer = errorConsumer;
        this.env = env;
        this.nodeExecutableOrigin = nodeExecutableOrigin;
    }

    public void start() {
        try {
            LOG.debug("Launching command {}", (Object)this.toString());
            this.process = this.processWrapper.startProcess(this.command, this.env, this.outputConsumer, this.errorConsumer);
        }
        catch (IOException e) {
            throw new NodeCommandException("Error when running: '" + this.toString() + "'. Is Node.js available during analysis?", e);
        }
    }

    private static List<String> buildCommand(String nodeExecutable, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(nodeExecutable);
        result.addAll(nodeJsArgs);
        if (scriptFilename != null) {
            result.add(scriptFilename);
        }
        result.addAll(args);
        return result;
    }

    public int waitFor() {
        try {
            int exitValue;
            boolean success = this.processWrapper.waitFor(this.process, 1L, TimeUnit.MINUTES);
            if (success) {
                exitValue = this.processWrapper.exitValue(this.process);
            } else {
                LOG.error("Node.js process did not stop in a timely fashion");
                this.processWrapper.destroyForcibly(this.process);
                exitValue = -1;
            }
            return exitValue;
        }
        catch (InterruptedException e) {
            this.processWrapper.interrupt();
            LOG.error("Interrupted while waiting for Node.js process to terminate.");
            return 1;
        }
    }

    public String toString() {
        return String.join((CharSequence)" ", this.command);
    }

    public Version getActualNodeVersion() {
        return this.actualNodeVersion;
    }

    public String getNodeExecutableOrigin() {
        return this.nodeExecutableOrigin;
    }
}

