/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;

class ReversePathTree {
    private Node root = new Node();

    ReversePathTree() {
    }

    void index(InputFile inputFile, String[] path) {
        Node currentNode = this.root;
        for (int i = path.length - 1; i >= 0; --i) {
            currentNode = currentNode.children.computeIfAbsent(path[i], e -> new Node());
        }
        currentNode.file = inputFile;
    }

    InputFile getFileWithSuffix(String[] path) {
        Node currentNode = this.root;
        for (int i = path.length - 1; i >= 0; --i) {
            currentNode = currentNode.children.get(path[i]);
            if (currentNode != null) continue;
            return null;
        }
        return ReversePathTree.getFirstLeaf(currentNode);
    }

    private static InputFile getFirstLeaf(Node node) {
        while (!node.children.isEmpty()) {
            node = node.children.values().iterator().next();
        }
        return node.file;
    }

    static class Node {
        final Map<String, Node> children = new LinkedHashMap<String, Node>();
        InputFile file = null;

        Node() {
        }
    }
}

