/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.plugins.javascript.lcov.FileLocator;

class LCOVParser {
    private static final String SF = "SF:";
    private static final String DA = "DA:";
    private static final String BRDA = "BRDA:";
    private final Map<InputFile, NewCoverage> coverageByFile;
    private final SensorContext context;
    private final Set<String> unresolvedPaths = new LinkedHashSet<String>();
    private final FileLocator fileLocator;
    private int inconsistenciesCounter = 0;
    private static final Logger LOG = LoggerFactory.getLogger(LCOVParser.class);

    private LCOVParser(List<String> lines, SensorContext context, FileLocator fileLocator) {
        this.context = context;
        this.fileLocator = fileLocator;
        this.coverageByFile = this.parse(lines);
    }

    static LCOVParser create(SensorContext context, List<File> files, FileLocator fileLocator) {
        LinkedList<String> lines = new LinkedList<String>();
        for (File file : files) {
            try {
                Stream<String> fileLines = Files.lines(file.toPath());
                try {
                    lines.addAll(fileLines.toList());
                }
                finally {
                    if (fileLines == null) continue;
                    fileLines.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read content from file: " + String.valueOf(file), e);
            }
        }
        return new LCOVParser(lines, context, fileLocator);
    }

    Map<InputFile, NewCoverage> coverageByFile() {
        return this.coverageByFile;
    }

    List<String> unresolvedPaths() {
        return new ArrayList<String>(this.unresolvedPaths);
    }

    int inconsistenciesNumber() {
        return this.inconsistenciesCounter;
    }

    private Map<InputFile, NewCoverage> parse(List<String> lines) {
        HashMap<InputFile, FileData> files = new HashMap<InputFile, FileData>();
        FileData fileData = null;
        int reportLineNum = 0;
        for (String line : lines) {
            ++reportLineNum;
            if (line.startsWith(SF)) {
                fileData = files.computeIfAbsent(this.inputFileForSourceFile(line), inputFile -> inputFile == null ? null : new FileData((InputFile)inputFile));
                continue;
            }
            if (fileData == null) continue;
            if (line.startsWith(DA)) {
                this.parseLineCoverage(fileData, reportLineNum, line);
                continue;
            }
            if (!line.startsWith(BRDA)) continue;
            this.parseBranchCoverage(fileData, reportLineNum, line);
        }
        HashMap<InputFile, NewCoverage> coveredFiles = new HashMap<InputFile, NewCoverage>();
        for (Map.Entry e : files.entrySet()) {
            NewCoverage newCoverage = this.context.newCoverage().onFile((InputFile)e.getKey());
            ((FileData)e.getValue()).save(newCoverage);
            coveredFiles.put((InputFile)e.getKey(), newCoverage);
        }
        return coveredFiles;
    }

    private void parseBranchCoverage(FileData fileData, int reportLineNum, String line) {
        try {
            String[] tokens = line.substring(BRDA.length()).trim().split(",");
            String lineNumber = tokens[0];
            String branchNumber = tokens[1] + tokens[2];
            String taken = tokens[3];
            fileData.addBranch(Integer.valueOf(lineNumber), branchNumber, "-".equals(taken) ? 0 : Integer.valueOf(taken));
        }
        catch (Exception e) {
            this.logWrongDataWarning("BRDA", reportLineNum, e);
        }
    }

    private void parseLineCoverage(FileData fileData, int reportLineNum, String line) {
        try {
            String execution = line.substring(DA.length());
            String executionCount = execution.substring(execution.indexOf(44) + 1);
            String lineNumber = execution.substring(0, execution.indexOf(44));
            fileData.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
        }
        catch (Exception e) {
            this.logWrongDataWarning("DA", reportLineNum, e);
        }
    }

    private void logWrongDataWarning(String dataType, int reportLineNum, Exception e) {
        LOG.debug("Problem during processing LCOV report: can't save {} data for line {} of coverage report file ({}).", dataType, reportLineNum, e.toString());
        ++this.inconsistenciesCounter;
    }

    @CheckForNull
    private InputFile inputFileForSourceFile(String line) {
        String filePath = line.substring(SF.length());
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasPath(filePath));
        if (inputFile == null) {
            inputFile = this.fileLocator.getInputFile(filePath);
        }
        if (inputFile == null) {
            this.unresolvedPaths.add(filePath);
        }
        return inputFile;
    }

    private static class FileData {
        private Map<Integer, Map<String, Integer>> branches = new HashMap<Integer, Map<String, Integer>>();
        private Map<Integer, Integer> hits = new HashMap<Integer, Integer>();
        private final int linesInFile;
        private final String filename;
        private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";

        FileData(InputFile inputFile) {
            this.linesInFile = inputFile.lines();
            this.filename = inputFile.filename();
        }

        void addBranch(Integer lineNumber, String branchNumber, Integer taken) {
            this.checkLine(lineNumber);
            Map branchesForLine = this.branches.computeIfAbsent(lineNumber, l -> new HashMap());
            branchesForLine.merge(branchNumber, taken, Integer::sum);
        }

        void addLine(Integer lineNumber, Integer executionCount) {
            this.checkLine(lineNumber);
            this.hits.merge(lineNumber, executionCount, Integer::sum);
        }

        void save(NewCoverage newCoverage) {
            for (Map.Entry<Integer, Integer> entry : this.hits.entrySet()) {
                newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            for (Map.Entry<Integer, Object> entry : this.branches.entrySet()) {
                int line = entry.getKey();
                int conditions = ((Map)entry.getValue()).size();
                int covered = 0;
                for (Integer taken : ((Map)entry.getValue()).values()) {
                    if (taken <= 0) continue;
                    ++covered;
                }
                newCoverage.conditions(line, conditions, covered);
                newCoverage.lineHits(line, this.hits.getOrDefault(line, 0) + covered);
            }
        }

        private void checkLine(Integer lineNumber) {
            if (lineNumber < 1 || lineNumber > this.linesInFile) {
                throw new IllegalArgumentException(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNumber, this.filename));
            }
        }
    }
}

