/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;
import org.sonar.plugins.javascript.lcov.ReversePathTree;

class FileLocator {
    private final ReversePathTree tree = new ReversePathTree();

    FileLocator(Iterable<InputFile> inputFiles) {
        inputFiles.forEach(inputFile -> {
            String[] path = inputFile.relativePath().split("/");
            this.tree.index((InputFile)inputFile, path);
        });
    }

    @CheckForNull
    InputFile getInputFile(String filePath) {
        String sanitizedPath = PathUtils.sanitize((String)filePath);
        if (sanitizedPath == null) {
            return null;
        }
        String[] pathElements = sanitizedPath.split("/");
        return this.tree.getFileWithSuffix(pathElements);
    }
}

